classdef sigmoidGlobalModel < globalModel
    
    % LMNtool - Local Model Network Toolbox
    % Tobias Ebert, 24-April-2012
    % Institute of Mechanics & Automatic Control, University of Siegen, Germany
    % Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles
    
    properties
        smoothness = 1;             % 1 x 1     global smoothness value for all local model transitions
    end
    
    
    methods
        [outputModel, phi] = calculateModelOutput(obj, input, output)
        [outputModel, phi] = calculateModelOutputCentered(obj, input, output)
        obj                = addChildren(obj, parentIdx, splittingParameter, center, parameter)
        [phi, phiMemory]   = calculatePhi(obj, zRegressor, idx, phiMemory)
    end
    
    methods(Hidden)
        [outputModel,phi] = simulateParallel(obj, xRegressor, zRegressor)
    end
    
    methods
        
        %% Constructor
        function GM = sigmoidGlobalModel
            
        end
        
        %% SET and GET
        function obj = set.smoothness(obj, value)
            if ~isscalar(value)
                error('localModel:set:smoothness','smoothness must be a scalar')
            end
            obj.smoothness = value;
            % Update localSmoothness for all local models
            if ~isempty(obj.localModels)
                % for idx = 1:size(obj.localModels,2)
                %    obj.localModels(idx).localSmoothness = value;
                % end
                [obj.localModels.localSmoothness] = deal(value);
            end
        end
    end
    
    
end

