function psi = calculatePsi(obj, zRegressor)
% CALCULATEPSI calculate the psi values of the data for this local model
%
%   psi = obj.calculatePsi(zRegressor)
%
%
% OUTPUTS:
%   psi         (N x 1)     Psi values.
%
%
% INPUTS:
%   zRegressor  (N X nz)    Regression matrix/Regressors for rule premises.
%
%
% SYMBOLS AND ABBREVIATIONS
%
% LM:  Local model
%
% p:   Number of inputs (physical inputs)
% q:   Number of outputs
% N:   Number of data samples
% M:   Number of LMs
% nx:  Number of regressors (x)
% nz:  Number of regressors (z)

% LMNtool - Local Model Network Toolbox
% Tobias Ebert, 24-April-2012
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles

% 2011/11/28:   help updated

psi = 1./(1+exp( ...
    (1./obj.localSmoothness) .* ( zRegressor*obj.splittingParameter(1:end-1) + obj.splittingParameter(end))...
    ));

end

