function y = demoFunctions(u,bsp)

% HILOMOT Nonlinear System Identification Toolbox
% Benjamin Hartmann, 01-June-2011
% Institute of Automatic Control & Mechatronics, Faculty of Science and Technology, University of Siegen, Germany
% Copyright (c) 2011 by Benjamin Hartmann


n = size(u,2); % number of input dimensions

if n==1 && ~ischar(bsp)
    switch bsp
        case 1
            y = sqrt(2)*sin(u) + sqrt(2)*cos(u) + 1/(2*sqrt(2))*sin(2*u) + 1/(sqrt(2))*cos(2*u) - sqrt(2)*sin(3*u) + sqrt(2)*cos(3*u);
        case 2
            y = zeros(size(u,1),1);
            y(u<0.3)=8-30*u(u<0.3).^3;
            y(u>=0.3) = 5+5*u(u>=0.3).^2;
        case 3
            v1 = 1;
            v0 = 0.65;
            smoothness = 3;
            sigmoide = 1./(1+exp((-v0+v1*u)/v1/smoothness*20));
            y2 = 0.1./(0.1+u);
            y1 = 1+sin(4*pi*u-pi/8);
            y = y1.*sigmoide + y2.*(1-sigmoide);
        case 4
            y = 0.1./(0.1+u);
        case 5
            u = 3.5*u - 1.5;%linspace(-1.5,2,100)';
            z = (u-0.2)/0.4;
            z = (u-0.2)/0.4; r = 0.05*(z.^3-3*z)/sqrt(6);
            y = 1-u+u.^2+r;
    end

end
if n>=2 && ~ischar(bsp)
    u1=u(:,1); u2=u(:,2);
    switch bsp
        case 1
            y = 0.1./(0.1+0.5*(1-u1)+0.5*(1-u2));
        case 2
            y = 0.1./(0.1+0.3*(1-u1)+0.7*(1-u2));
        case 3
            y = u1.^2.*sqrt(u2);
        case 4
            y = 0.01./((1.1-u1).*(1.1-u2));
        case 5
            y = 2-2*exp(-0.5*((u1-0.25).^2+(u2-0.25).^2));
        case 6 %Mars
            y = 2*exp(8*((u1-0.5).^2+(u2-0.5).^2))./(exp(8*((u1-0.2).^2+(u2-0.7).^2))+exp(8*((u1-0.7).^2+(u2-0.2).^2)));
        case 7
            y = 2*sin(2*pi*u1).*(u2-0.5).^2;
        case 8
            y = exp(-25*((u1-0.5).^2+(u2-0.5).^2));
        case 9
            y = 0.25*cos(3*pi/2*u1.*(1+pi/2*u1.^2))+pi/2*u2;
        case 10
            y = 2*sin(2*pi*u1).*(u2-0.5).^2;
        case 11 %Branin
            u1f = u1*15-5; u2f = u2*15; y = (u2f-(5.1/(4*pi^2))*u1f.^2 + 5*u1f/pi-6).^2 + 10*(1-1/(8*pi))*cos(u1f)+10;
        case 12
            y = cos(9*sqrt(u1.^2+u2.^2) + 2) + 0.5*cos(11*u1+2) + 15*( (u1-0.4).^2 + (u2-0.4).^2 ).^2;
        case 13
            y = exp( -( 15*(u1-0.3).^2 + 38*(u2-0.5).^2 - 32*(u1-0.3).*(u2-0.5) ) );
        case 14
            idx = u1>1-u2;
            u11 = u1(idx);  u21 = u2(idx);
            u12 = u1(~idx); u22 = u2(~idx);
            y = zeros(size(u,1),1);
            y(idx)  = 5 + 3*u11 + 7*u21.^3;
            %y(~idx) = 1 + u12.^2 + 0.5*u22;
        case 15
            y  = 5 + 3*u1 + 7*u2.^3;
        case 16
            y = sin(4*pi*(u1 + u2.^2)/2);
        case 17
            y = 0.5./(0.5+0.5*(1-u1)+0.5*(1-u2.^2));
        case 18
            y = exp( -( 15*(u1-0.3).^2 + 38*(u2-0.5).^2 - 32*(u1-0.3).*(u2-0.5) ) );% + gauss([u1 u2],[1 1],0.15);
            
    end
else
    switch bsp
        case 'hyperbel'
            y = hyperbel(u,n);
        case 'parabola'
            y = parabola(u,n);
        case 'perm'
            u = u*2*n-n;
            y = perm(u,n);
        case 'trid'
            u = u*2*n^2-n^2;
            y = trid(u,n);
%         case 'zakh'
%             u = u*15-5;
%             y = zakh(u,n);
        case 'hyperbelGauss'
            c       = zeros(1,n); % Centers for Gaussian
            sigma   = 0.25;        % Standard deviation (equally for all inputs)
            hheight = 1;          % Maximum height of the Gaussian function
            gheight = 0.75;        % Maximum height of the hyperbola function
            y = hheight*hyperbel(u,n) + (gheight-hyperbel(c,n))*gauss(u,c,sigma);
        case 'gauss'
            c       = ones(1,n)/2; % Centers for Gaussian
            sigma   = 0.25;        % Standard deviation (equally for all inputs)
            y = gauss(u,c,sigma);
        case 'hypSin'
            y = hypSin(u);
        case 'wellen'
            y = wellen(u,n);
        case 'radcos'
            y = Radcos(u,n);
    end
end

% Normalization to interval [0,1]
% y = (y-min(y))./(max(y)-min(y));


end


function y = hyperbel(u,n)
%
% Hyperbel function y = 0.1/(0.1+(1-u(1))/n+(1-u(2))/n+ ... +(1-u(n))/n)
% Matlab Code by B. Hartmann (Oct. 13, 2010)
%
den = 0.1;
for i = 1:n
    den = den+(1-u(:,i))/n;
end
y = 0.1./den;
end

function y = parabola(u,n)
%
% Parabola function y = 1-sum (u(i)-0.5)^2
% Matlab Code by B. Hartmann (Oct. 13, 2010)
%
y = 1;
for i = 1:n
    y = y-(u(:,i)-0.5).^2;
end
end

function y = perm(u,n)
%
% Perm function
% Matlab Code by A. Hedar (Nov. 23, 2005).
% The number of variables n should be adjusted below.
% The default value of n = 4.
%
b = 0.5;
s_out = 0;
for k = 1:n;
    s_in = 0;
    for j = 1:n
        s_in = s_in+(j^k+b)*((u(:,j)/j).^k-1);
    end
    s_out = s_out+s_in.^2;
end
y = s_out;
end

function y = trid(u,n)
%
% Trid function
% Matlab Code by A. Hedar (Nov. 23, 2005).
% The number of variables n should be adjusted below.
% The default value of n = 10.
%
s1 = 0;
s2 = 0;
for j = 1:n;
    s1 = s1+(u(:,j)-1).^2;
end
for j = 2:n;
    s2 = s2+u(:,j).*u(:,j-1);
end
y = s1-s2;
end

function y = gauss(u,c,sigma)
[N n] = size(u);
x = zeros(N,1);
for i = 1:n
    x = x + ((u(:,i)-c(i))/sigma).^2;
end
y = exp(-0.5*x);
end


function y = hypSin(u)

p = size(u,2);

% y2 = 0.1./(0.1+1-(1/p*sum(u,2)));


% v = ones(1,p);
% v0 = 1;
% smoothness = 1;
% 
% 
% sigmoide = 1./(1+exp((-v0+sum(u,2))/sqrt(p)/smoothness*20));

y = (1+sin(4*pi*sum(u,2)/p - pi/8))/2.*(1-sum(u,2)/p);


% y = y1.*sigmoide + y2.*(1-sigmoide);




end

function y = wellen(u,n)
%


y =zeros(size(u,1),1);


for dim = 1:n
    
    ci = mod(dim^3+3,5)+1;
    di = mod(dim^7+3,11)/10;
    
    y = y + sin(ci*(u(:,dim)+di));
    
    if dim<n
        y = y + exp(u(:,dim).*u(:,dim+1));
    else
        y = y + exp(u(:,1).*u(:,n));
    end
    
end
end

function y = Radcos(u,n)

if n == 2
    y = cos(9*sqrt(u(:,1).^2+u(:,2).^2) + 2) + 0.5*cos(11*u(:,1) +2) + 15*( (u(:,1)-0.4).^2 + (u(:,2)-0.4).^2 ).^2 ;

else
    
F1 = ones(size(u,1),1);
F2 = zeros(size(u,1),1);
for d = 3:n
    F1 = F1 + u(:,d);
    b = 1+5*(d-3);
    a = 0.6/(1+b);
    F2 = F2 + (u(:,d) - a*(b*u(:,1) + 1 - u(:,2)) -0.2).^2;
end

y = cos(9*sqrt(u(:,1).^2+u(:,2).^2) + 2) + 0.5*cos(8*u(:,1).*( F1 ) +2) + 15*( (u(:,1)-0.4).^2 + (u(:,2)-0.4).^2 ).^2 + 15./(sqrt(n-2))*F2;
end


end

