function visualizeSensitivityResults(obj)
% Visualizes the results from a sensitivity analysis run via an horizontal
% barplot
%
% visualizeSensitivityResults(obj)
%
% INPUTS
%
% obj:          (sensitivityAnalysis-object)

% Julian Belz, 19th-July-2012
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles

% Visualization is only possible, if results are existing
if size(obj.sensitivityResults,2) > 0
    % Open figure, get screensize and position the figure
    scrsize = get(0,'screensize');
    width = scrsize(3)/3;
    height = scrsize(4)/4*3;
    fh = figure;
    set(fh,'Position',[(scrsize(3) - width)/2 (scrsize(4) - height)/2 width height]);
    
    % Define font, fontsize and axes
    font = 'Arial';
    fontsize = 13;
    ah = axes;
    
    % Loop for every input combination to create designations
    designation = cell(size(obj.combinationMatrix,1),1);
    for ii=1:size(obj.combinationMatrix,1)
        if sum(obj.combinationMatrix(ii,:),2) < (size(obj.combinationMatrix,2)/2)
            colums = find(obj.combinationMatrix(ii,:));
            str = makeDesignationString(colums);
            designation{ii,1} = ['+[',str,']'];
        else
            colums = find(obj.combinationMatrix(ii,:)==0);
            str = makeDesignationString(colums);
            designation{ii,1} = ['-[',str,']'];
        end
    end
    
    barh(ah,obj.sensitivityResults.lossFunctionValue);
    set(ah,'yTickLabel',designation,'FontName',font,'FontSize',fontsize);
end

    function str = makeDesignationString(indices)
        if size(indices,2) == 0
            str = '';
        elseif size(indices,2)==1;
            str = num2str(indices);
        else
            str = num2str(indices(1));
            for kk=2:size(indices,2)
                str = [str,'; ',num2str(indices(kk))]; %#ok<AGROW>
            end
        end
        
    end

end