%% Hyperbel Example

clear; clear all; close all; clc;

%% Define Process and 'measured' data
pointsPerAxis   = 40;
uAxis           = linspace(0,1,pointsPerAxis)';
U               = makeBenchInputND(2,uAxis);
u1g             = reshape(U(:,1),pointsPerAxis,pointsPerAxis);
u2g             = reshape(U(:,2),pointsPerAxis,pointsPerAxis);
yOblique        = benchFunktionND(U,'obliqueHyperbel');
yObliqueG       = reshape(yOblique,pointsPerAxis,pointsPerAxis);

y               = benchFunktionND(U,'hyperbel');
yG              = reshape(y,pointsPerAxis,pointsPerAxis);

prozessAusgaenge= {yObliqueG,yG,yObliqueG,yG};
bezeichnung     = {'30-60 Grad Hyperbel','45-45 Grad Hyperbel'};

%% Plot options
scrsize         = get(0,'ScreenSize');
width           = 800;
height          = 600;
pos             = [(scrsize(3)-width)/2 (scrsize(4)-height)/2 width height];
linewidth       = 2;
fontname        = 'Arial';
fontsize        = 14;

figure('Position',pos);
ah              = cell(1,4);

%% Visualisierung
for ii=1:4
    
    ah{ii} = subplot(2,2,ii);
    if ii<3
        surf(ah{ii},u1g,u2g,prozessAusgaenge{ii});
        ht = title(ah{ii},bezeichnung{ii});
    else
        contour(ah{ii},u1g,u2g,prozessAusgaenge{ii});
    end
    
    hx = xlabel(ah{ii},'u_1');
    hy = ylabel(ah{ii},'u_2');
    hz = zlabel(ah{ii},'y');
    
    set([hx,hy,hz,ht,ah{ii}],'FontName',fontname,'FontSize',fontsize);
    
end