%% Ablauf Skript

%% Add toolbox to matlab path
%  Unbedingt darauf achten, dass sich die Toolbox im Matlab-Pfad befindet!
pp = path;
toolbox = genpath('Toolbox');
path(toolbox,pp);

%% RBF- vs. NRBF-Netz
% Reaktivierung zeigen!
nrbf_netz;

%% LOLIMOT Training Schritt fuer Schritt
lolimotTrainingStepByStep;

%% Effekt von 'Smoothness'
clear; clear all; close all; clc;
% Bei konstantem Rauschlevel Smoothness variieren
smoothnessNoiseLevel;

%% Globale vs. Lokale Modellparameterschaetzung
clear; clear all; close all; clc;
% 3 verschiedene Konfigurationen von Smoothness und Rauschlevel
% 1. kein Rauschen, scharfe Uebergaenge
% 2. kein Rauschen, 'sinnvolle' Uebergaenge
% 3. Rauschen, 'sinnvolle Uebergaenge
% Seeding abschalten und Ergebnisse fr verschiedene Rauschrealisierungen
% ansehen
localVSglobalParameterEstimation;

%% Einfluss von Rauschen
clear; clear all; close all; clc;
% Datenanzahl anpassen (51 und 301)
N = 301; 
differentNoiseLevel(N);
differentNoiseLevel_globalEstimation(N);



%% Ab hier 2 dimensionaler Eingangsraum



%% Visualisierung der verwendeten Funktionen
clear; clear all; close all; clc;
hyperbolaExample;

%% HILOMOT Training die ersten drei Schritte (45-45)
clear; clear all; close all; clc;
lmn=lolimotTrainingStepByStep2d;

%% Fertiges Netz in GUI visualisieren
GUIvisualize(lmn);

%% HILOMOT Training die ersten drei Schritte (30-60)
clear; clear all; close all; clc;
lmn=lolimotTrainingStepByStep2d('obliqueHyperbel');

%% Fertiges Netz in GUI visualisieren
GUIvisualize(lmn);



%% Optional, falls noch Zeit ist...



%% HILOMOT Beispiel (45-45)
clear; clear all; close all; clc;
hilomotTrainingStepByStep2d;

%% Fertiges Netz in GUI visualisieren
GUIvisualize(lmn);

%% Visualisierung Hyperbel+Ebene
clear; clear all; close all; clc;
hyperbolaPlane;

%% Hyperbel mit Ebene ueberlagert
clear; clear all; close all; clc;
% 1. Ohne Rauschen
% 2. Mit Rauschen
noiseLevel = 0.05;
lmn = hyperbelPlusEbene(noiseLevel);

%% Netz Visualisieren
GUIvisualize(lmn);


%% Falls noch viel mehr Zeit...
% Lokale Polynome hoeherer Ordnung --> Linear vs Quadratisch (bei geringen
% Eingangsraumdimensionen kaum mehr Aufwand, ABER Curse of Dimensionality
% durch Kreuzterme...
