classdef dataSetInfo
    % dataSetInfo creates an object, that contains information about a
    % dataSet object, such as the dataSet description and the description
    % of all in- and outputs.
    %
    %
    % PROPERTYS
    %
    % inputDescription:     (1 x p) Cell-Array
    % outputDescription:    (1 x q) Cell-Array
    % dataSetDescription:           String
    % samplingTime          (1 x 1) Sampling time of the dynamic systems
    %
    %
    % SYMBOLS AND ABBREVIATIONS:
    %
    % LM:  Local model
    %
    % p:   Number of inputs (physical inputs)
    % q:   Number of outputs
    % N:   Number of data samples
    % M:   Number of LMs
    % nx:  Number of regressors (x)
    % nz:  Number of regressors (z)
    %
    %
    % LMNtool - Local Model Network Toolbox
    % Julian Belz, 21-November-2011
    % Institute of Mechanics & Automatic Control, University of Siegen, Germany
    % Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles

    
    properties
        inputDescription        % Description of the inputs
        outputDescription       % Description of the outputs
        dataSetDescription      % Description of a dataSet object
        samplingTime            % sampling time of the dynamic systems
    end
    
    methods
        function info = dataSetInfo(dsName)
            % Constructor for a dataSetInfo object, where a description of
            % a dataSet object can be passed directly
            %
            %
            % info = dataSetInfo(dsName)
            %
            %
            % INPUT
            %
            % dsName:       String, which describes a dataSet object
            %
            %
            % OUTPUT
            %
            % info:         dataSetInfo object
            
            if nargin == 0 || isempty(dsName)
                dsName = 'No Description';
            end
            
            info.dataSetDescription = dsName;
            
        end % end constructor
        
    end
    
end

