classdef estimateLocalModels
    % ESTIMATELOCALMODELS estimates the model parameters of a given local
    % model object.
    %
    % ESTIMATELOCALMODELS estimates the coefficients of a polynomial.
    % Therefore it uses the very powerful Q-R-factorization to
    % solve the least-squares-problem. Alternatively the user can decide
    % to use only a few of all possible regressors by changing the
    % property "estimationProcedure" to "STEPWISE_LS".
    %
    %
    % PROPERTIES:
    %
    % estimateProcedure:  (string)  Precedure that is used for estimation.
    %                               (default: 'LS')
    %
    %
    % EXPLANATIONS:
    %
    %   "estimateProcedure": This property indicates which procedure should
    %   be used to estimate the coefficients of the polynomial. 
    %   "LS" uses the complete given xRegressor for the approximation by
    %   solving the least-sqares-problem. 
    %   "STEPWISE_LS" uses "stepwisefit" to search for a specific number of
    %   the given xRegressors depending on their importance. Afterwards
    %   their coefficients are estimate by least-squares.
    %   "RIDGE" uses ridge regression to calculat the model parameters
    %
    %
    % LMNtool - Local Model Network Toolbox
    % Torsten Fischer, 17-November-2011
    % Institute of Mechanics & Automatic Control, University of Siegen, Germany
    % Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles
    
    % 18.11.11 help updated (TE)

    
    properties
        estimationProcedure = 'LS'; % Precedure that is used for estimation.
        LOOCV = false;              % Flag for Leave-one-out cross validation.
    end
    
    properties(Hidden=true) % Hidden because they are only necassary 
        minErrorImprovement = 1e-3; 
        thresholdLinearDependency = 1e-5;
    end
    
    
    methods
        [coeff pseudoInv] = estimateParametersLocal(obj,xRegressor, output, validityFunctionValue, numberOfCoeff, dataWeighting)
        [coeff pseudoInv] = estimateParametersGlobal(obj,xRegressor, output, validityFunctionValue, numberOfCoeff, dataWeighting)
    end
    
    methods(Static)
        [selectedRegressors, errorImprovement, linearDependentRegressors] = orthogonalLeastSquares(xRegressorWeighted, outputWeighted, numberOfCoeff, minErrorImprovement, thresholdLinearDependency)
        [B,SE,PVAL,in,stats,nextstep,history] = stepwiseWeighted(allx,y,varargin)
        [B,SE,PVAL,in,stats,nextstep,history] = stepwiseWeighted2011a(allx,y,varargin)
        [theta, inmodel] = WLSBackwardElimination(XAll,y,phi,inmodel,keepcols)
    end
    
end
