function phi = calculatePhi(obj,zRegressor,idx)
% CALCULATEPHI callculates the validity functino values (phi) of every z
% regressor for every local model
%
% [phi,phiMemory] = obj.calculatePhi(zRegressor,idx,phiMemory)
%
% INPUTS:
%   zRegressor
%   idx         (1 x M) logical vector of active local models
%
% OUTPUTS:
%   phi
%
%
% LMNtool - Local Model Network Toolbox
% Tobias Ebert, 15-March-2012
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles

% NOTE: You should NOT use this function in a training algorithm, as it
% always does a recalculation of the MSF values, which consumes a lot of
% time

% calculate the MSF Value of all active models
MSFValue = arrayfun(@(loc) loc.calculateMSF(zRegressor),obj.localModels(idx),'UniformOutput',false);

% calculate normalized gaussians
phi = obj.calculateVFV(MSFValue);