classdef globalModel < regressor & lossFunction & estimateLocalModels & terminationCriterions
    % GLOBALMODEL superclass for global models to reduce overhead with universal
    % functions
    
    
    %   suggestedNet:
    %   It decribes which net structure in the net object has the best
    %   performance/complexity trade-off.
    
    %   idxAllowedLM:
    %   This logical vector stores the information if a local model is
    %   allowed to be splitted. That check is only needed if intertpretable
    %   areas are intended. If any areas are allowed, all possible splits
    %   can be done.
    
    properties
        history = [];               % class     history class stores information concerning the training algorithmn
        kStepPrediction = 0;        % scalar    0 or 1 for static model or one-step-predictor, inf for dynamic calculation
        leafModels = []             % 1 x M     logical vector, true for active models, false for inactive models
        idxAllowedLM = [];          % 1 x M     stores the allowed local models with respect to splitting
        localModels = [];           % 1 x M     cell array of all local models objects
        numberOfInputs = [];        % 1 x 1     number of all physical inputs, set in training
        numberOfOutputs = [];       % 1 x 1     number of all physical outputs, set in training        
        pointsPerLMFactor = 1;      % 1 x 1     factor that defines the minimum number of points that have to be in a LM before it is allowed for splitting
        
    end
    
    properties(Dependent = true, SetAccess = private)
        suggestedNet                % 1 x 1     suggested net with best performance/complexity trade-off
    end
    
    methods(Static,Hidden)
        outputModel = calcYhat(xRegressor,validityFunctionValue,parameter)
    end
    
    %% Constructor
    methods
        function GM = globalModel
            GM.history = modelHistory;
        end
    end
    
    %% SET and GET methods
    methods
        function suggestedNet = get.suggestedNet(obj)
            if isempty(obj.history)
                % if there is no history, return empty answer
                suggestedNet = [];
            else
                % if the history is of type modelHistory then...
                if ~isempty(obj.history.validationDataLossFunction)
                    % check if there is validation data...
                    [~, idxBest] = min(obj.history.validationDataLossFunction);
                else
                    % ... or only the AIC
                    [~, idxBest] = min(obj.history.penaltyLossFunction);
                end                
                suggestedNet = idxBest;
            end

        end
        
        function obj = set.idxAllowedLM(obj,value)
            if islogical(value)
                obj.idxAllowedLM = value;
            else
                error('globalModel:set:idxAllowedLM','Value must be logical!')
            end
        end
    end
    
end

