function obj = defaultLMNSet( obj )
%DEFAULTSET Classify current LMN object and indiviually set default values for training according to a given
%data set.

% Benjamin Hartmann, 23-December-2011
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2011 by Prof. Dr.-Ing. Oliver Nelles



% Check regressors for rule premises (z) and rule consequents (x)
if isprop(obj,'xRegressor') && isempty(obj.xRegressor)
    obj.xRegressor = data2xRegressor(obj,obj.input,obj.output);
end
if isprop(obj,'zRegressor') && isempty(obj.zRegressor)
    obj.zRegressor = data2zRegressor(obj,obj.input,obj.output);
end

% Get constants for complexity considerations
N  = size(obj.output,1);
nx = size(obj.xRegressor,2);
nz = 0;


% Custom options for each LMN approach
if any(strcmp(superclasses(obj),'sigmoidGlobalModel'))
    % Count sigmoid parameters, if splitting is axes-oblique
    if isprop(obj,'oblique') && obj.oblique % Case hilomot
        nz = size(obj.zRegressor,2);
    elseif ~isprop(obj,'oblique') % Case hiromerge
        nz = size(obj.zRegressor,2);
    end
end

% M is not given
if isprop(obj,'maxNumberOfLM') && isempty(obj.maxNumberOfLM)
    % Calculate maxNumberOfLM per default: M = (N+nz)/(nx+nz)
    obj.maxNumberOfLM = round( (N+nz)/(nx+nz) );
    fprintf('\nIntended number of local models to train: %d\n',obj.maxNumberOfLM)
end
% Ensure that at least 1 LM is given
if isprop(obj,'maxNumberOfLM') && obj.maxNumberOfLM == 0
    obj.maxNumberOfLM = 1;
    if displayMode
        fprintf('\nData is too sparse for given setup! Maximum number of local models is set to 1.')
    end
end
% Only M is given
if isprop(obj,'maxNumberOfParameters') && isempty(obj.maxNumberOfParameters)
    %     if isprop(obj,'maxNumberOfLM')
    %         % Default: maxNumberOfParameters nAll = M*nx + (M-1)*nz
    %         obj.maxNumberOfParameters = obj.maxNumberOfLM*nx + (obj.maxNumberOfLM-1)*nz;
    %     else
    obj.maxNumberOfParameters = N; % Needed in case of globalPolynom or LMNs with Subset Selection (e.g. polymot)
    %     end
end
% Factor for variance penalty term in AIC criterion
if isprop(obj,'complexityPenalty')
    obj.complexityPenalty = 1;
end
% Default smoothness value
if isprop(obj,'smoothness')
    obj.smoothness = 1;
end
% Maximum trianing time for each LMN approach: 60 minutes
if isprop(obj,'maxTrainTime')
    obj.maxTrainTime = 60;
end
% Min error zero, because complexity is already considered with maxNumberOfLM
if isprop(obj,'minError')
    obj.minError = 0;
end

end

