function data = unscale( obj, data)
% UNSCALE unscales the given data according to the scaling parameters in
% the class
%
%   unscaledData = unscale( obj, scaledData)
%
% INPUTS:
%
% data  (N x dim)   unscaled data
%
% OUTPUTS:
%
% data  (N x dim)           scaled data
%
% SYMBOLS AND ABBREVIATIONS
%
% LM:  Local model
% p:   Number of inputs (physical inputs)
% q:   Number of outputs
% N:   Number of data samples
% M:   Number of LMs
% nx:  Number of regressors (x)
% nz:  Number of regressors (z)

% LMNtool - Local Model Network Toolbox
% Tobias Ebert, 24-April-2012
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles

switch obj.method
    case 'unitVarianceScaling'
        
        data = unscaleUnitVarianceScaling(data, obj.parameter);
        
    case 'boxcox'
        
        data = unscaleBoxCox(data, obj.parameter);
        
    %case 'orthogonalScaling'
        
    otherwise
        
        error('The method you specified is not allowed')
        
end

end


%% unitVarianceScaling
function data = unscaleUnitVarianceScaling(data, parameter)
    data = bsxfun(@plus,bsxfun(@times,data,parameter.std),parameter.mean);
end

%% box cox
function data = unscaleBoxCox(data, parameter)

% reverse boxcox transformation
if parameter.lambda == 0
    data = bsxfun(@minus,exp(data)-eps,parameter.offset);
else
    data = bsxfun(@minus,((data .* parameter.lambda) + 1) .^ (1/parameter.lambda),parameter.offset);
end


end




