function obj = addChildren(obj,parent,splittingParameter,center,parameter)
% add a children knot to the tree
%
% INPUTS:
%   parentIdx           index of parent knot. if empty, new knot is considered to be the root
%   splittingParameter  (optional) sigmoid parameter of the new knot
%   center              (optional) center of the new knot
%   parameter           (optional) parameter of the new local model

% LMNtool - Local Model Network Toolbox
% Benjamin Hartmann, 28-Oct-2011
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles


if ~exist('parent','var')
    parent = [];
end
if ~exist('splittingParameter','var')
    splittingParameter = [];
end
if ~exist('center','var')
    center = [];
end
if ~exist('parameter','var')
    parameter = [];
end

if isempty(obj.localModels)
    % the new knot is the root knot
    obj.localModels = sigmoidLocalModel(parent,splittingParameter,center,parameter);
else
    % add a new child
    obj.localModels(end+1) = sigmoidLocalModel(parent,splittingParameter,center,parameter);
    % get child idx
    childIdx = length(obj.localModels);
    % add the child index to the parent model
    obj.localModels(parent).children(end+1) = childIdx;
    % use the smoothness of the parent
    obj.localModels(childIdx).localSmoothness = obj.localModels(parent).localSmoothness;
end


end

