classdef sigmoidLocalModel
    % SIGMOIDLOCALMODEL is class to construct sigmoid based local models
    %
    %   obj = sigmoidLocalModel(parent, splittingParameter, center, parameter)
    %
    %
    % PROPERTIES:
    %
    %   center                  (1 x nz)    Vector of the center
    %                                       coordinates (default: []).
    %   
    %   parameter               (nx x q)    Vector/matrix of local model
    %                                       parameters (default: []).
    %
    %   localLossFunctionValue  (scalar)    The local loss function value
    %                                       (default: []).
    %
    %   parent                  (scalar)    Index of parent knot (default:
    %                                       []).
    %
    %   children                (1 x ?)     Indices of children knots
    %                                       (default: []).
    %
    %   splittingParameter      (nz+1 x 1)  Parameter of the sigmoid
    %                                       (default: []).
    %
    %   localSmoothness         (scalar)    Smoothness parameter (default:
    %                                       1).
    %
    %
    % SYMBOLS AND ABBREVIATIONS
    %
    % LM:  Local model
    %
    % p:   Number of inputs (physical inputs)
    % q:   Number of outputs
    % N:   Number of data samples
    % M:   Number of LMs
    % nx:  Number of regressors (x)
    % nz:  Number of regressors (z)
    
    % LMNtool - Local Model Network Toolbox
    % Tobias Ebert, 24-April-2012
    % Institute of Mechanics & Automatic Control, University of Siegen, Germany
    % Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles
    
    % 2011/11/28:   help updated (TE)
    
    properties
        center      = [];   % (1 x nz)    vector of the center coordinates
        parameter   = [];   % (nx x q)    vector/matrix of local model parameters
        localLossFunctionValue = [];  % (scalar) the local loss function value
        parent      = []    % (scalar)    index of parent knot
        children    = []    % (1 x ?)     indices of children knots
        splittingParameter = []; % (nz+1 x 1) parameter of the sigmoid
        localSmoothness = 1;    % (scalar)  smoothness parameter
        pseudoInv = [];
    end
    
    methods
        psi = calculatePsi(obj, zRegressor)
    end
    
    methods
        % Constructor
        function obj = sigmoidLocalModel(parent, splittingParameter, center, parameter)
            if nargin>=1
                obj.parent = parent;
                if nargin>=2
                    obj.splittingParameter = splittingParameter;
                    if nargin>=3
                        obj.center = center;
                        if nargin>=4
                            obj.parameter = parameter;
                        end
                    end
                end
            end
        end

        % SET and GET methods, to prevent errors later
        function obj = set.localSmoothness(obj,value)
            if ~isscalar(value)
                error('sigmoidLocalModel:set:smoothness','smoothness must be a scalar')
            end
            obj.localSmoothness = value;
        end
    end
    
end

