function obj = dataSet2model(obj,dataSetObject)
dsClass     = class(dataSetObject);
if strcmp(dsClass,'dataSet')
    % Get all properties of the dataset class, that has to be passed to the
    % model object
    names   = properties('dataSet');
    
    % Only independent properties can be passed. Dependent properties
    % within the dataset class are the 'unscaledInput' and the
    % 'unscaledOutput'. These two properties has to be deleted from the
    % 'names' cell. Some properties of the regressor class are deleted as well.
    idx1  = strcmp(names,'unscaledInput');
    idx2  = strcmp(names,'unscaledOutput');
    idx3  = strcmp(names,'xInputDelay');
    idx4  = strcmp(names,'zInputDelay');
    idx5  = strcmp(names,'xOutputDelay');
    idx6  = strcmp(names,'zOutputDelay');
    idx   = abs((idx1 + idx2 + idx3 + idx4 + idx5 +idx6) - 1);
    names = names(logical(idx),1);
    
    for ii=1:size(names,1)
        eval(['obj.',names{ii,1},'=dataSetObject.',names{ii,1},';']);
    end
    
else
    warning('Input argument must be an dataSet-class-object'); %#ok<WNTAG>
    return;
end
end % end dataSet2model