function [obj,showTraining] = editTrainOptions(obj,showTraining)
% Advanced settings for the model training

% Definitions
bgcolor  = [0.7 0.7 0.7];
white    = [1 1 1];
scrsize  = get(0,'screensize');
width    = 760;

textH    = 16;
textHBig = 20;
textW    = 0.55*width;
editH    = 20;
editW    = 0.4*width;
cbW      = 20;
cbH      = 20;
hButton  = 20;
fontsize = 12;
fontsizeBig = 14;
fontname = 'Times New Roman';
xposT    = 10;
xposE    = 0.55*width;
deltaSp  = 28;
deltaSpG = 30;
topMar   = 10;
minEdit  = 2;
% Positions of components

classname = class(obj);
if strcmp(classname,'hilomotSubset')
    classname = 'hilomot';
end
    
switch classname
    case 'hilomot'
        anzahlOptionen = 13;
        height   = 4*deltaSpG+3*2*deltaSpG+(anzahlOptionen-3)*deltaSp+2*topMar+textHBig;

        posfh    = [(scrsize(3)-width)/2,...
            (scrsize(4)-height)/2,...
            width height];
        
        % Main Figure
        fh = figure('Visible','off',...
            'Units','pixels',...
            'MenuBar','none',...
            'ToolBar','figure',...
            'Position',posfh,...
            'Tag','mainFigure',...
            'Color',bgcolor);
        
        yaktuell = height-topMar-textHBig;
        
        ht{1,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textHBig],...
            'FontSize',fontsizeBig,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Termination criteria options');
        
        yaktuell = yaktuell - deltaSpG;
        
        ht{2,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Maximum number of local models:');
        
        if obj.maxNumberOfLM == 0
            wert = 20;
        elseif isempty(obj.maxNumberOfLM)
            wert = 20;
        else
            wert = obj.maxNumberOfLM;
        end
        
        he{1,1} = uicontrol('Parent',fh,...
            'Style','edit',...
            'Position',[xposE yaktuell-minEdit editW editH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'String',num2str(wert));
        
        yaktuell = yaktuell-deltaSp;
        
        ht{3,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Minimum number of points per local model:');
        
        % If there is no numberOfPoints-property and no input-property
        % defined, the minimum number of data points within a local
        % model is set to 0.
        if isempty(obj.numberOfPoints)
            if isempty(obj.input)
                minPoints = 0;
            else
                minPoints = 2*(size(obj.input,2)+1);
            end
        else
            minPoints = obj.numberOfPoints;
        end
        
        he{2,1} = uicontrol('Parent',fh,...
            'Style','edit',...
            'Position',[xposE yaktuell-minEdit editW editH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'String',num2str(minPoints));
        
        yaktuell = yaktuell-deltaSp;
        
        ht{4,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Abort training as soon as reaching a train error smaller than:');
        
        he{3,1} = uicontrol('Parent',fh,...
            'Style','edit',...
            'Position',[xposE yaktuell-minEdit editW editH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'String',num2str(obj.minError));
        
        yaktuell = yaktuell-2*deltaSpG;
        
        ht{5,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textHBig],...
            'FontSize',fontsizeBig,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Local model options');
        
        yaktuell = yaktuell-deltaSpG;
        
        ht{6,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Local loss function criterion:');
        
        he{4,1} = uicontrol('Parent',fh,...
            'Style','edit',...
            'Position',[xposE yaktuell-minEdit editW editH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'String',obj.lossFunctionLocal);
        
        yaktuell = yaktuell-deltaSp;
        
        ht{7,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Polynomial degree of local models:');
        
        he{5,1} = uicontrol('Parent',fh,...
            'Style','edit',...
            'Position',[xposE yaktuell-minEdit editW editH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'String',num2str(obj.xRegressorDegree));
        
        yaktuell = yaktuell - deltaSp;
        
        ht{8,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Polynomial degree of local models:');
        
        if strcmp(obj.xRegressorType,'polynomial')
            tmpvalue = 1;
        else
            tmpvalue = 2;
        end
        
        hpop{1,1} = uicontrol('Parent',fh,...
            'Style','popupmenu',...
            'Position',[xposE yaktuell-minEdit editW editH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'Value',tmpvalue,...
            'String',{'polynomial','sparsePolynomial'});
        
        yaktuell = yaktuell - 2*deltaSpG;
        
        ht{9,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textHBig],...
            'FontSize',fontsizeBig,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Partitioning options');
        
        yaktuell = yaktuell - deltaSpG;
        
        ht{10,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Smoothness (hard: 0.1; smooth: 3):');
        
        he{6,1} = uicontrol('Parent',fh,...
            'Style','edit',...
            'Position',[xposE yaktuell-minEdit editW editH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'String',num2str(obj.smoothness));
        
        yaktuell = yaktuell-deltaSp;
        
        ht{11,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Oblique partitioning:');
        
        hcb{1,1} = uicontrol('Parent',fh,...
            'Style','checkbox',...
            'Position',[xposE yaktuell-minEdit cbW cbH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'Value',obj.oblique,...
            'String','');
        
        yaktuell = yaktuell-deltaSp;
        
        ht{14,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Analytical gradient:');
        
        hcb{4,1} = uicontrol('Parent',fh,...
            'Style','checkbox',...
            'Position',[xposE yaktuell-minEdit cbW cbH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'Value',obj.optGrad,...
            'String','');
        
        yaktuell = yaktuell - 2*deltaSpG;
        
        ht{15,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textHBig],...
            'FontSize',fontsizeBig,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','General options');
        
        yaktuell = yaktuell - deltaSpG;
        
        ht{16,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Show information about the training within the command window:');
        
        hcb{5,1} = uicontrol('Parent',fh,...
            'Style','checkbox',...
            'Position',[xposE yaktuell-minEdit cbW cbH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'Value',showTraining,...
            'String','');
        
        yaktuell = yaktuell-deltaSp;
        
        ht{17,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String',...
            'Visualize split optimization:');
        
        hcb{6,1} = uicontrol('Parent',fh,...
            'Style','checkbox',...
            'Position',[xposE yaktuell-minEdit cbW cbH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'Value',0,...
            'Enable','off',...
            'String','');
        
        yaktuell = yaktuell - deltaSpG;
        
    case 'lolimot'
        anzahlOptionen = 8;
        height   = 4*deltaSpG+3*2*deltaSpG+(anzahlOptionen-3)*deltaSp+2*topMar+textHBig;
%         height = 750;
        posfh    = [(scrsize(3)-width)/2,...
            (scrsize(4)-height)/2,...
            width height];
        
        % Main Figure
        fh = figure('Visible','off',...
            'Units','pixels',...
            'MenuBar','none',...
            'ToolBar','figure',...
            'Position',posfh,...
            'Tag','mainFigure',...
            'Color',bgcolor);
        
        yaktuell = height-topMar-textHBig;
        
        ht{1,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textHBig],...
            'FontSize',fontsizeBig,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Termination criteria options');
        
        yaktuell = yaktuell - deltaSpG;
        
        ht{2,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Maximum number of local models:');
        
        if isempty(obj.maxNumberOfLM)
            wert = inf;
        else
            wert = obj.maxNumberOfLM;
        end
        
        he{1,1} = uicontrol('Parent',fh,...
            'Style','edit',...
            'Position',[xposE yaktuell-minEdit editW editH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'String',num2str(wert));
        
        yaktuell = yaktuell-deltaSp;
        
        ht{3,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Abort training as soon as reaching a train error smaller than:');
        
        if isempty(obj.minError)
            obj.minError = 0;
        end
        
        he{2,1} = uicontrol('Parent',fh,...
            'Style','edit',...
            'Position',[xposE yaktuell-minEdit editW editH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'String',num2str(obj.minError));
        
        yaktuell = yaktuell-2*deltaSpG;
        
        ht{4,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textHBig],...
            'FontSize',fontsizeBig,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Local model options');
        
        yaktuell = yaktuell-deltaSpG;
        
        ht{5,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Polynomial degree of local models:');
        
        he{3,1} = uicontrol('Parent',fh,...
            'Style','edit',...
            'Position',[xposE yaktuell-minEdit editW editH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'String',num2str(obj.xRegressorDegree));
        
        yaktuell = yaktuell - deltaSp;
        
        ht{6,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Polynomial degree of local models:');
        
        if strcmp(obj.xRegressorType,'polynomial')
            tmpvalue = 1;
        else
            tmpvalue = 2;
        end
        
        hpop{1,1} = uicontrol('Parent',fh,...
            'Style','popupmenu',...
            'Position',[xposE yaktuell-minEdit editW editH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'Value',tmpvalue,...
            'String',{'polynomial','sparsePolynomial'});
        
        yaktuell = yaktuell - 2*deltaSpG;
        
        ht{7,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textHBig],...
            'FontSize',fontsizeBig,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Partitioning options');
        
        yaktuell = yaktuell - deltaSpG;
        
        ht{8,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Global smoothness (hard: 0.1; smooth: 3):');
        
        he{4,1} = uicontrol('Parent',fh,...
            'Style','edit',...
            'Position',[xposE yaktuell-minEdit editW editH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'String',num2str(obj.smoothness));
        
        yaktuell = yaktuell-deltaSp;
        
        ht{9,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Number of splits tested in each dimension:');
        
        he{5,1} = uicontrol('Parent',fh,...
            'Style','edit',...
            'Position',[xposE yaktuell-minEdit editW editH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'String',num2str(obj.splits));
        
        yaktuell = yaktuell - 2*deltaSpG;
        
        ht{10,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textHBig],...
            'FontSize',fontsizeBig,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','General options');
        
        yaktuell = yaktuell - deltaSpG;
        
        ht{11,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String','Show information about the training within the command window:');
        
        hcb{1,1} = uicontrol('Parent',fh,...
            'Style','checkbox',...
            'Position',[xposE yaktuell-minEdit cbW cbH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'Value',showTraining,...
            'String','');
        
        yaktuell = yaktuell-deltaSp;
        
        ht{17,1} = uicontrol('Parent',fh,...
            'Style','text',...
            'Position',[xposT yaktuell textW textH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'HorizontalAlignment','left',...
            'String',...
            'Complexity penalty:');
        
        he{6,1} = uicontrol('Parent',fh,...
            'Style','edit',...
            'Position',[xposE yaktuell-minEdit editW editH],...
            'FontSize',fontsize,...
            'FontName',fontname,...
            'String',num2str(obj.complexityPenalty));
        
        yaktuell = yaktuell - deltaSpG;
end

hButtonUebernehmen = uicontrol('Parent',fh,...
    'Style','Pushbutton',...
    'String','Accept',...
    'Enable','on',...
    'FontSize',fontsize,...
    'FontName',fontname,...
    'Position',[xposT yaktuell 100 hButton],...
    'Callback',@uebernehmen);

set([ht{:},hButtonUebernehmen],'BackgroundColor',bgcolor);
set([he{:},hcb{:}],'BackgroundColor',white);
% set([ht{:},hButtonUebernehmen,he{:}],'Units','normalized');

set(fh,'Visible','on');


    function uebernehmen(hObject,eventdata)
        size(hObject);
        size(eventdata);
        
        switch classname
            case 'hilomot'
                % Not implemented yet: 'Visualize split optimization'
                
                tmp = obj;
                
                tmp.maxNumberOfLM = str2double(get(he{1,1},'String'));
                
                tmp.numberOfPoints = str2double(get(he{2,1},'String'));
                
                tmp.minError = str2double(get(he{3,1},'String'));
                
                tmp.lossFunctionLocal = get(he{4,1},'String');
                
                tmp.xRegressorDegree = str2double(get(he{5,1},'String'));
                
                popupvalue   = get(hpop{1,1},'value');
                popupstring = get(hpop{1,1},'String');
                tmp.xRegressorType = popupstring{popupvalue};
                
                tmp.smoothness = str2double(get(he{6,1},'String'));
                
                tmp.oblique = get(hcb{1,1},'Value');
                
%                 tmp.transitionAdjustment = get(hcb{2,1},'Value');
                
%                 tmp.centerMonteCarlo = get(hcb{3,1},'Value');
                
                tmp.optGrad = get(hcb{4,1},'Value');
                
                obj = tmp;
                
                if get(hcb{5,1},'value')
                    showTraining = true;
                else
                    showTraining = false;
                end
                
                close(fh);
            case 'lolimot'
                
                tmp = obj;
                
                tmp.maxNumberOfLM = str2double(get(he{1,1},'String'));
                
                tmp.minError = str2double(get(he{2,1},'String'));
                
                tmp.xRegressorDegree = str2double(get(he{3,1},'String'));
                
                popupvalue   = get(hpop{1,1},'value');
                popupstring = get(hpop{1,1},'String');
                tmp.xRegressorType = popupstring{popupvalue};
                
                tmp.smoothness = str2double(get(he{4,1},'String'));
                
                tmp.splits = str2double(get(he{5,1},'String'));
                
                tmp.complexityPenalty = str2double(get(he{6,1},'String'));
                
                obj = tmp;
                
                if get(hcb{1,1},'value')
                    showTraining = true;
                else
                    showTraining = false;
                end
                
                close(fh);
        end
    end
waitfor(fh);
end % end editTrainOptions