function cvOptions = setCVoptions(numberOfBatches,modelComplexities)
% Function creates a structure, that contains information for a cross
% validation
%
% cvOptions = setCVoptions(numberOfBatches,modelComplexities)
%
% Inputs
%
% numberOfBatches:      Integer; Defines the number of batches for the
%                       crossvalidation
% modelComplexities:    (1 x number of model complexities) vector
%                       containing only integer values; every integer value
%                       determines a model complexity for which the
%                       crossvalidation value should be calculated.
%                       Example: modelComplexities = [3 5] --> The
%                       crossvalidation values for 3 and 5 local models
%                       will be calculated.
%
% Output
%
% cvOptions:            Structure with fields: numberOfBatches and
%                       modelComplexities

% Julian Belz, 19-Mrz-2012
% Institut fr Mess- und Regelungstechnik, Universitt Siegen, Deutschland
% Institute of Measurement and Control, University of Siegen, Germany
% Copyright (c) 2012 by Julian Belz

if nargin < 2
    cvOptions.modelComplexities     = 1:10;
else
    cvOptions.modelComplexities     = modelComplexities;
end

if nargin < 1
    cvOptions.numberOfBatches       = 2;
else
    cvOptions.numberOfBatches       = numberOfBatches;
end



end