function phi = calculateValidityFunctionAllClasses(obj,zRegressor)
% This function calculates the validity values to a given zRegressor and
% xRegressor
%
%   phi = calculateValidityFunctionAllClasses(obj,zRegressor,xRegressor)
%
% INPUTS
%
% obj:              lmnGUIBuild-object
% zRegressor:       [number of points] x [number of physical inputs] 
%                   regressor-matrix
% xRegressor:       
% 
% OUTPUTS
%
% phi:              [number of points] x [number of local models]
%                   validity values for each point in each local model

if nargin == 1
    zRegressor = obj.data2zRegressor(obj.input);
end

classname = class(obj);

% switch classname
%     case 'lolimot'
%         % Calculate Validity values
%         MSFValue = arrayfun(@(loc) loc.calculateMSF(zRegressor),obj.localModels(obj.leafModels),'UniformOutput',false);
%         phi     = cell2mat(obj.calculateVFV(MSFValue));
%     case 'hilomot' || 'hilomotSubset'
        phi     = obj.calculatePhi(zRegressor,obj.leafModels);
        if iscell(phi)
            phi = cell2mat(phi);
        end
% end

end % end calculateValidityFunctionAllClasses