% demo for example data
clc
%clear all
close all

% Set random number generator for reproducibility
rng(23,'twister')

% create the training data:
[trainingInput, trainingOutput, examplelStruct] = exampleFunctions('hypGauss', 2, 'linear', 900, 0.01);

% create the test data
[testInput, testOutput] = exampleFunctions([], [], 'spacefill', 100, 0, examplelStruct);


figure
% plot training data. Surf may be used as the data is on a grid
htrain = surf(reshape(trainingInput(:,1),sqrt(size(trainingInput,1)),sqrt(size(trainingInput,1))),...
reshape(trainingInput(:,2),sqrt(size(trainingInput,1)),sqrt(size(trainingInput,1))),...
reshape(trainingOutput,sqrt(size(trainingInput,1)),sqrt(size(trainingInput,1))));
set(htrain,'FaceAlpha',0.4)
camlight left
lighting phong

% plot test data
hold on
htest = plot3(testInput(:,1),testInput(:,2),testOutput,'or');
legend(htest,'testInput')
hold off

% set axis labels
xlabel('u1')
ylabel('u2')
zlabel('y')


%{
polynom
stenman
sinus1
step
quadroot
linroot
%}