function [input, output, inputText, outputText] = exampleData(name)
% exampleData is a simple script to provide preprocessed data
%
%   [input, output, inputText, outputText] = exampleData(name)
%
% INPUTS:
%
%   name
%   (string) name of the data set
%
% OUTPUTS
%
%   input
%   the input data of the measurement
%
%   output
%   the output data of the measurements
%
%   inputText
%   (cellarray with strings) names of the inputs
%
%   outputText
%   (cellarray with strings) names of the outputs

switch name
    
    case 'daimlerdiesel2008'
        % measurement of a daimler diesel engine
        [input, output, inputText, outputText] = exampleData_daimlerdiesel2008;
        
    case 'daimlerdiesel2008_reduced'
        % reduced measurement of a daimler diesel engine
        [input, output, inputText, outputText] = exampleData_daimlerdiesel2008_reduced;
        
    otherwise
        disp('Allowed data set names are:')
        disp('daimlerdiesel2008')
        disp('daimlerdiesel2008_reduced')
        error('name of the dataset is unknown')
        
end

% warn if NaN or INF values are present
if any(any(isnan(input)))
    warning(['Attention: There are NaN values in output ' num2str(find(any(isnan(input))))])
end
if any(any(isinf(input)))
    warning(['Attention: There are inf values in output ' num2str(find(any(isinf(input))))])
end
if any(any(isnan(output)))
    warning(['Attention: There are NaN values in output ' num2str(find(any(isnan(output))))])
end
if any(any(isinf(output)))
    warning(['Attention: There are inf values in output ' num2str(find(any(isinf(output))))])
end

end

%% example 'daimlerdiesel2008_reduced'
function [input, output, inputText, outputText] = exampleData_daimlerdiesel2008_reduced
% measurements from a daimler diesel engine from 2008 with reduced in-
% or outputs

disp('This is the dataset limited to the')
disp('inputs u1 u2 u3 u7 u11 and the')
disp('outputs y1 y2 y3 y4 y5')

load exampleData_daimlerdiesel2008.mat data

input  = data(:,[1, 2, 3, 7, 11]);
output = data(:,12:16);

inputText{1} = 'Drehmoment Md [Nm]';
inputText{2} = 'Drehzahl n [min-1]';
inputText{3} = 'Saugrohrdruck p2i [mbar]';
inputText{4} = 'AGR-Rate [%]';
inputText{5} = 'Ansteuerbeginn Haupteinspritzung ABHE [KW n.OT]';

outputText{1} = 'NOX [g/h]';
outputText{2} = 'Ru [g/h]';
outputText{3} = 'HC [g/h]';
outputText{4} = 'CO [g/h]';
outputText{5} = 'effektiver Kraftstoffverbrauch b_eff [g/kWh]';


%disp('Attention: Output 13 has NaN values for sample 1314:end,')

end

%% example 'daimlerdiesel2008'
function [input, output, inputText, outputText] = exampleData_daimlerdiesel2008
% measurements from a daimler diesel engine from 2008 without reduced in-
% or outputs

disp('This is the dataset without reduced in- and outputs.')
disp(' The most important in- and outputs are given in daimlerdiesel2008_reduced')

load exampleData_daimlerdiesel2008.mat data

input  = data(:,1:11);
output = data(:,12:24);

inputText{1} = 'Drehmoment Md [Nm]';
inputText{2} = 'Drehzahl n [min-1]';
inputText{3} = 'Saugrohrdruck p2i [mbar]';
inputText{4} = 'Drallklappenstellung EKAS [%]';
inputText{5} = '1. Voreinspritzung Menge VE2 [mm^3/Hub]';
inputText{6} = 'Ansteuerbeginn 1. Voreinspritzung ABVE2 [?sek]';
inputText{7} = 'AGR-Rate [%]';
inputText{8} = 'Ansteuerbeginn 2. Voreinspritzung ABVE1 [msek]';
inputText{9} = '2. Voreinspritzung Menge VE1 [mm?/Hub]';
inputText{10} = 'Raildruck p_CR [bar]';
inputText{11} = 'Ansteuerbeginn Haupteinspritzung ABHE [KW n.OT]';

outputText{1} = 'NOX [g/h]';
outputText{2} = 'Ru [g/h]';
outputText{3} = 'HC [g/h]';
outputText{4} = 'CO [g/h]';
outputText{5} = 'effektiver Kraftstoffverbrauch b_eff [g/kWh]';
outputText{6} = 'Motorgerusch LVG2 [dBA]';
outputText{7} = 'ME-Mime [mm?/Hub]';
outputText{8} = 'Varianz indizierter Mitteldruck s_Ind [-]';
outputText{9} = 'Lage des Verbrennungsschwerpunktes H50 [?KW n. OT]';
outputText{10} = 'BOSCH-Schwrzungszahl FSN [-]';
outputText{11} = 'Einspritzmenge gesamt q_raw [mm?/Hub]';
outputText{12} = 'Lambdawert Lambda [Sonde]';
outputText{13} = 'Stellung AGR-Ventil_Sollwert AGR soll [%]';

disp('Attention: Output 13 has NaN values for sample 1314:end,')

end


