classdef globalPolynom < regressor & lossFunction & estimateLocalModels & dataSet
    % This class has the ability to estimate a global polynom model for the
    % given inputs and simulate an output for test data
    %
    % You may use a constructor of the following form:
    %
    % obj = globalPolynom(input,output,noOfParameter)
    %
    % If you want to use a dynamic model you must specify xRegressorDelay
    
    % Tobias Ebert, 11-Oct-2011
    % Institut fr Mess- und Regelungstechnik, Universitt Siegen, Deutschland
    % Institute of Measurement and Control, University of Siegen, Germany
    % Copyright (c) 2011 by Tobias Ebert
    
    properties
        
        numberOfInputs = [];
        numberOfOutputs = [];
        localModels
        xRegressor
        leafModels
        history
        
        % termination criterions
        maxTrainTime = inf;
        maxNumberOfParameters = 500; % Number of Parameters to be estimated
        minError = 0;
        maxIterations = inf;
        
        suggestedNet
        
    end
    
    properties(Hidden=true)
        
        zRegressor = [];
    end
    
    methods
        obj = train(obj,displayMode) % Train a global Polynom
        yhat = calculateModelOutput(obj,input,output) % simulate an output
        
    end
    
    methods
        %% CONSTUCTOR
        function obj = globalPolynom(varargin)
            
            if nargin >= 1
                obj.input = varargin{1};
            end
            if nargin >= 2
                obj.output = varargin{2};
            end
            if nargin >= 3
                obj.noOfParameter = varargin{3};
            end
            obj.estimationProcedure = 'STEPWISE_LS';
            
            obj.history = modelHistory;
        end
    end
end






