function GM = demo
clc
close all

% reset random number generator
rng('default')



GM = globalPolynom;

%% Generate training data and store in object

% 1D grid
% LMN.input  = linspace(0,1,10)';
%  LMN.input  = rand(7,1);
% LMN.input = [0 0.2 0.59 0.6 0.8 1]';

% 2D grid
 [u1g u2g]   = meshgrid(linspace(0,1,11));
 GM.input  = [u1g(:) u2g(:)];
% LMN.input  = rand(300,2);

% 4D grid
% [u1g u2g u3g u4g]   = ndgrid(linspace(0,1,10));
% LMN.input  = [u1g(:) u2g(:) u3g(:) u4g(:)];

% 9D random
% LMN.input  = rand(2000,9);


% output process: 
% exponential function
datafun = @(x) 1./(0.1+1-(1/size(x,2)*sum(x,2)));
% 'quadratic'
% datafun = @(x) real((prod(x-0.5,2).^(1./size(x,2))).^2); % 14.07.2011

% gernerate output
GM.output = datafun(GM.input);
% add noise
GM.output = GM.output + 0.01*randn(size(GM.output))*(max(GM.output)-min(GM.output));

%% globales Model trainieren

% try 5 and 50 parameters
GM.maxNumberOfParameters = inf;

GM = GM.train(true);

figure
GM.plotModel

figure
GM.plotLossFunction 
 

end