% DEMOHILOMOTCLASS demonstrates the functioning of the HILOMOT toolbox for a nonlinear
% static regression example.

% HILOMOTDOE Nonlinear System Identification Toolbox for Design of Experiments
% Benjamin Hartmann, 25-November-2011
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2011 by Prof. Dr.-Ing. Oliver Nelles


% clear all
clear
close all
clc
% clear java

% Add path of HILOMOT class files
% restoredefaultpath
% hilomotDirectory = fileparts(which(mfilename));
% addpath(hilomotDirectory);
% cd(hilomotDirectory); cd ..
% addpath(pwd);
% genpath('exampleDataAndFunctions');

% Initialize hilomot object
LMN = hilomot;

% User defined options
% LMN.minError = 0.05;
LMN.maxNumberOfLM = 19;
% LMN.maxNumberOfParameters = 100;
% LMN.optGrad = 0;
% LMN.smoothness = 1.5;
% LMN.oblique = 1;

% LMN.maxTrainTime = 5/60;
% LMN.complexityPenalty = 1;

% LMN.zInputDelay{1} = [];
% LMN.zInputDelay{2} = [0];

LMN.xRegressorDegree = 1;

% Generate training data and store in hilomot object
% 1D grid
% LMN.input  = linspace(0,1,300)';
% 2D grid
% [u1g u2g]   = meshgrid(linspace(0,1,20));
% LMN.input  = [u1g(:) u2g(:)];
% 4D grid
% [u1g u2g u3g u4g]   = ndgrid(linspace(0,1,10));
% LMN.input  = [u1g(:) u2g(:) u3g(:) u4g(:)];
% 9D random
% LMN.input  = rand(2000,9);
% LMN.output = demoFunctions(LMN.input,'hyperbelGauss');
% 
% LMN.output = LMN.output+0.02*randn(size(LMN.output))*(max(LMN.output)-min(LMN.output));

% [trainingInput, trainingOutput, examplelStruct] = exampleFunctions('exponential', 1, 'linear', 200, 0);

rng(23)
% Create training data:
[LMN.input, LMN.output, examplelStruct] = exampleFunctions(1, 1, 'linear', 30, 0.05);

% Create test data
% [testInput, testOutput] = exampleFunctions([], [], 'spacefill', 100, 0, examplelStruct);




% Train LMN object with hilomot class
tic
LMN = LMN.train;
toc



idxBest = LMN.suggestedNet;
LMNBest = LMN;
LMNBest.leafModels = LMN.history.leafModelIter{LMN.suggestedNet};
% LMNBest.leafModels = LMN.history.leafModelIter{1};

% Plot model vs. process and partitioning
% figure
% LMN.plotModel
% figure
% LMN.plotPartition


options.plotMethod = 'contour'
figure; LMN.plotPartition([],[],options)


figure
LMN.plotModel
% title('AIC-Auswahl')
% % figure
% % LMNBest.plotPartition
% 
% figure
% LMN.plotLossFunction
% 

figure
plot(1:length(LMN.history.localCVLossFunction),LMN.history.penaltyLossFunction)
figure
plot(1:length(LMN.history.localCVLossFunction),LMN.history.localCVLossFunction)


% figure
% % GPE = LMN.history.penaltyLossFunction;
% % GPE = (GPE-min(GPE))./(max(GPE)-min(GPE))+eps;
% semilogy(1:sum(LMN.leafModels),LMN.history.penaltyLossFunction)
% 
% 
% figure
% 
% plot(1:sum(LMN.leafModels),LMN.history.globalLossFunction)