% DEMOHILOMOTDOECLASS demonstrates the functioning of the HILOMOTDOE toolbox for a nonlinear
% static regression example.

% HILOMOTDOE Nonlinear System Identification Toolbox for Design of Experiments
% Benjamin Hartmann, 25-November-2011
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2011 by Prof. Dr.-Ing. Oliver Nelles

% clear all
clear
close all
clc

% Add path of HILOMOT class files
% restoredefaultpath
% hilomotDirectory = fileparts(which(mfilename));
% addpath(hilomotDirectory);

% Initialize hilomot object
design = hilomotDoE;

% User defined options
design.numberOfInitialPoints = 3;
design.smoothnessQuery = 1.5;

% Option for implementation of variable increments
% design.variableIncrements = [0 0.02 1; 0 0.03 1];

% Example selection 1, ..., 13
example = 1;

% Standard deviation of white noise
noiseLevel = 0.0;


[u1g u2g] = meshgrid(linspace(0,1,30), linspace(0,1,30));
u1Plot = u1g(:);
u2Plot = u2g(:);
yPlot = demoFunctions([u1Plot u2Plot],example) + noiseLevel*rand(size(u1Plot,1),1);

figure(24)
surf(u1g,u2g,reshape(yPlot,30,30))
set(gca,'fontsize',13)
title('Process that has to be measured','fontsize',13)
xlabel('u_1','fontsize',13)
ylabel('u_2','fontsize',13)
zlabel('y','fontsize',13)
pause(1)
close


% Generate candidate data set
load demoCandidatePoints.mat
design.candidatePoints = candidatePoints;
u1 = design.candidatePoints(:,1);
u2 = design.candidatePoints(:,2);
NCand = size(u1,1);

% Simulate measurement with example function:
y = demoFunctions([u1 u2], example) + noiseLevel*rand(size(u1,1),1);

% Initialization phase
[query] = design.DoEUpdate;

% Simulate measurement
yQuery = demoFunctions(query, example) + noiseLevel*rand(size(query,1),1);

% Generate data set: data = [u_ist y_ist u_soll]
design.inputTarget   = [design.inputTarget; query];
design.inputMeasured = [design.inputMeasured; query];
design.output        = [design.output; yQuery];

% Enable Active Learning procedure
design.flagSpaceFilling = false;

% Active learning phase
for k = 1:30
    
    % Perform active learning
    [query] = design.DoEUpdate;
    
    % Simulate measurement
    yQuery = demoFunctions(query, example) + noiseLevel*rand(size(query,1),1);
    
    % Generate data set: data = [u_ist y_ist u_soll]
    design.inputTarget   = [design.inputTarget; query];
    design.inputMeasured = [design.inputMeasured; query];
    design.output        = [design.output; yQuery];

    % Example for failed measurement
    if k == 911 || k == 923
        fprintf('\n\n -> Simulation of failed measurement! \n\n')
        pause(0.1)
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Important note for user, if measurement failed: 
        % Store query as target input. Store measured input and 
        % output as NaN!
        design.inputTarget(end,:)   = query;
        design.inputMeasured(end,:) = [NaN NaN];
        design.output(end)          = NaN;
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    end
    
    figure(23)
    plot(design.inputMeasured(:,1),design.inputMeasured(:,2),'k.','markersize',11,'linewidth',2); hold on
    plot(query(:,1),query(:,2),'ro','markersize',11,'linewidth',2); hold off
    set(gca,'fontsize',13,'XTick',[0 0.5 1],'YTick',[0 0.5 1])
    title('Selected measurement points (black) and new query point (red)','fontsize',13)
    xlabel('u_1','fontsize',13)
    ylabel('u_2','fontsize',13)
    axis([0 1 0 1])
    
end


% Plots

close all

figure(24)
surf(u1g,u2g,reshape(yPlot,30,30))
alpha(0.3); hold on
plot3(design.inputMeasured(:,1),design.inputMeasured(:,2),design.output,'ro','markersize',11,'linewidth',2)
set(gca,'fontsize',13)
title('Process and selected measurement points','fontsize',13)
xlabel('u_1','fontsize',13)
ylabel('u_2','fontsize',13)
zlabel('y','fontsize',13)

figure(25)
contour(u1g,u2g,reshape(yPlot,30,30))
hold on
plot3(design.inputMeasured(:,1),design.inputMeasured(:,2),design.output,'ro','markersize',11,'linewidth',2)
set(gca,'fontsize',13,'XTick',[0 0.5 1],'YTick',[0 0.5 1])
title('Process and selected measurement points','fontsize',13)
xlabel('u_1','fontsize',13)
ylabel('u_2','fontsize',13)


