% hilomotDemo1 Demo 1. Static process with 1 input and 1 output

% HiLoMoT - Nonlinear System Identification Toolbox
% Benjamin Hartmann, 04-April-2012
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles


% Initialize new hilomot object as local model network (LMN)
LMN = hilomot;

% Set input and output for training
LMN.input  = linspace(0,1,100)';
LMN.output = 1 ./ (0.1 + LMN.unscaledInput);

% Set minimum training error as termination criterion
LMN.minError = 0.05;

% Train hilomot object
LMN = LMN.train;

% Find best performance/complexity trade-off
[~, idxBest] = min(LMN.history.penaltyLossFunction);
LMNBest = LMN;
LMNBest.leafModels = LMN.history.leafModelIter{idxBest};

% Visualization
figure
LMNBest.plotModel
figure
LMNBest.plotPartition

% Generalization
uG = linspace(-0.05,1.2,270)';
yG = 1 ./ (0.1 + uG);

% Calculate model output and global loss function
yGModel = calculateModelOutput(LMNBest, uG, yG);
JG = calcGlobalLossFunction(LMNBest ,yG, yGModel);