% hilomotDemo4 Demo 4. Dynamic process of second order with 1 input and 1 output

% HiLoMoT - Nonlinear System Identification Toolbox
% Tobias Ebert, 11-May-2012
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles


% Training
hilomotObject = hilomot;                                   % initialize hilomot object

load hammersteinT.mat                                      % Data for training

% The training data was created with the input signal stored in inputSequence1.mat
% which contains steps and an amplitude-modulated pseudo random binary signal covering
% the complete operating range.
% The process to be modeled has the following dynamics:
% y(k) = 0.1044*atan(u(k-1)) + 0.0883*atan(u(k-2)) + 1.4138*y(k-1) - 0.6065*y(k-2);

hilomotObject.input = data(:,1);
hilomotObject.output = data(:,2);
clear data

hilomotObject.xInputDelay = cell(1,1);
hilomotObject.xOutputDelay = cell(1,1);
hilomotObject.zInputDelay = cell(1,1);
hilomotObject.zOutputDelay = cell(1,1);
hilomotObject.xInputDelay{1} = [1 2];                                % Second order dynamic system
hilomotObject.xOutputDelay{1} = [1 2];                               % Second order dynamic system
hilomotObject.zInputDelay{1} = [1 2];                                % Second order dynamic system
hilomotObject.zOutputDelay{1} = [1 2];                               % Second order dynamic system

% Try also the following cases:
% - Premise input space is only of first order
% hilomotObject.xInputDelay{1} = [1 2];
% hilomotObject.xOutputDelay{1} = [1 2];
% hilomotObject.zInputDelay{1} = [1];
% hilomotObject.zOutputDelay{1} = [1];
% - Premise input space does only contain the physical inputs (this reflects the Hammerstein structure)
% hilomotObject.xInputDelay{1} = [1 2];
% hilomotObject.xOutputDelay{1} = [1 2];
% hilomotObject.zInputDelay{1} = [1 2];
% hilomotObject.zOutputDelay{1} = [];
% - Local finite impulse response (FIR) models (no feedback is involved which requires high feedforward order)
% hilomotObject.xInputDelay{1} = [1:30];
% hilomotObject.xOutputDelay{1} = [];
% hilomotObject.zInputDelay{1} = [1 2];
% hilomotObject.zOutputDelay{1} = [];

hilomotObject.smoothness = 1;
hilomotObject.maxNumberOfLM = 10;                          % Termination criterion for maximal number of LLMs
hilomotObject.minError = 0.1;                              % Termination criterion for minimal error
hilomotObject.kStepPrediction = inf;                        % Simulation not one-step-ahead prediction
hilomotObject.history.displayMode = true;                   % display information

% Train net
hilomotObject = hilomotObject.train;

% Find best performance/complexity trade-off
[~, idxBest] = min(hilomotObject.history.penaltyLossFunction);
hilomotObject.leafModels = hilomotObject.history.leafModelIter{idxBest};

% Generalization
load hammersteinG.mat                                      % Data for generalization

% The generalization data was generated with the input signal stored in inputSequence2.mat.
uG = data(:,1);
yG = data(:,2);
clear data

% Simulate net
yGModel = calculateModelOutput(hilomotObject, uG, yG);
JG = calcGlobalLossFunction(hilomotObject ,yG, yGModel);

figure
hilomotObject.plotModel
% figure
% hilomotObject.plotMSFValue
% figure
% hilomotObject.plotPartition