% hilomotDemo1 Demo 1. Static process with 1 input and 1 output

% HiLoMoT - Nonlinear System Identification Toolbox
% Benjamin Hartmann, 04-April-2012
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles

close all

% Initialize new hilomot object as local model network (LMN)
LMN = hilomot;

% Set input and output for training
LMN.input  = linspace(0,1,20)';
LMN.output = 1 ./ (0.1 + LMN.unscaledInput);

% LMN.input  = [LMN.input; 0.7];
% LMN.output = [LMN.output; 6];

% Set minimum training error as termination criterion
LMN.minError = 0.05;
% LMN.zInputDelay = cell(1,1);
% LMN.zInputDelay{1} = [];
% LMN.maxNumberOfLM = 1;
LMN.oblique = true;

% Train hilomot object
LMN = LMN.train;

% Find best performance/complexity trade-off
LMNBest = LMN;
LMNBest.leafModels = LMN.history.leafModelIter{LMN.suggestedNet};

% Visualization
figure
LMNBest.plotModel
figure
LMNBest.plotPartition

% Generalization
uG = linspace(-0.05,1.2,270)';
yG = 1 ./ (0.1 + uG);

% Calculate model output and global loss function
yGModel = calculateModelOutput(LMNBest, uG, yG);
JG = calcGlobalLossFunction(LMNBest ,yG, yGModel);