%% Properties by Category
% Local Model Toolbox
% 
%
%% Data Set Properties
%
%
% * <input_help.html |input|> - (N x p) Matrix of the inputs
% * <scaleInput_help.html |scaleInput|> - (class) Scale input object
% * <output_help.html |output|> - (N x q) Matrix of the outputs.
% * <scaleOutput_help.html |scaleOutput|> - (class) Scale output object. Empty for no
% * <dataWeighting_help.html |dataWeighting|> - Weighting of the inputs.
% * <outputWeighting_help.html |outputWeighting|> - Weighting of the outputs.
% * <validationInput_help.html |validationInput|> - (? x p) Matrix of the validation data inputs.
% * <validationOutput_help.html |validationOutput|> - (? x q) Matrix of the validation data outputs.
% * <testInput_help.html |validationOutput|> - (? x p) Matrix of the test data inputs.
% * <testOutput_help.html |testOutput|> - (? x q) Matrix of the test data outputs.
% * <unscaledInput_help.html |unscaledInput|> - (N x p) Matrix of the unscaled inputs
% * <unscaledOutput_help.html |unscaledOutput|> - (N x q) Matrix of the unscaled outputs
% 
%
%
%% Termination Criterion Properties
%
%
% * <maxNumberOfLM_help.html |maxNumberOfLM|> - (1 x 1)           Maximum number of LLMs termination criterion
% * <minError_help.html |minError|> - (1 x 1)           Loss function threshold termination criterion
% * <maxNumberOfParameters_help.html |maxNumberOfParameters|> - (1 x 1)           Maximum number of Parameter termination criterion
% * <maxTrainTime_help.html |maxTrainTime|> - (1 x 1)           Maximum allowed time for the calculation
% * <maxIterations_help.html |maxIterations|> - (1 x 1)           Maximum number of iterations termination criterion
% * <maxPenaltyDeterioration_help.html |maxPenaltyDeterioration|> - (1 x 1)           Maximum number of deterioration of the penalty loss function
%
%
%% Lossfunction Properties
%
%
% * <lossFunctionGlobal_help.html |lossFunctionGlobal|> - Global lossfunction type ('MSE','RMSE','NMSE','NRMSE', 'MISCLASS' and 'R2' can be chosen).
% * <lossFunctionLocal_help.html |lossFunctionLocal|> - Local lossfunction type ('SE','RSE','DRSE' and 'MISCLASS' can be chosen).
% * <noiseVariance_help.html |noiseVariance|> - This property allows the user to define a certain process noise variance, based on prior knowledge about the process noise.
% * <complexityPenalty_help.html |complexityPenalty|> - Complexity penalty.
% * <estNoiseVariance_help.html |estNoiseVariance|> -
% * <crossvalidationValues_help.html |crossvalidationValues|> - Crossvalidation values for different model complexities
%
%
%% Other Properties
%
% * <info_help.html |info|> - Stores the data set informations
% * <history_help.html |history|> - (class) history class stores information concerning the training algorithmn
%
%
%% Global Model Properties
%
%
% * <estimationProcedure_help.html |estimationProcedure|> - Precedure that is used for estimation
% * <xRegressorDegree_help.html |xRegressorDegree|> - order of the polynomial within the regressor
% * <xRegressorMaxPower_help.html |xRegressorMaxPower|> - highest power within the regressor for polynomials
% * <xRegressorExponentMatrix_help.html |xRegressorExponentMatrix|> - exponent matrix for the regressors
% * <xRegressorType_help.html |xRegressorType|> - Type of regressor; 'polynomial' (default) or 'sparsePolynomial'
% * <xInputDelay_help.html |xInputDelay|> - Delays of the input regressors for rule consequents
% * <xOutputDelay_help.html |xOutputDelay|> - Delays of the output regressors for rule consequents
% * <zInputDelay_help.html |zInputDelay|> - Delays of the input regressors for rule premises
% * <zOutputDelay_help.html |zOutputDelay|> - Delays of the input regressors for rule premises
% * <smoothness_help.html |smoothness|> - Global smoothness value for all local model transitions
% * <kStepPrediction_help.html |kStepPrediction|> - (scalar) 0 or 1 for static model or one-step-predictor, inf for dynamic calculation
% * <leafModels_help.html |leafModels|> - (1 x M) logical vector, true for active models, false for inactive models
% * <localModels_help.html |localModels|> - (1 x M) cell array of all local models objects
% * <numberOfInputs_help.html |numberOfInputs|> - (1 x 1) number of all physical inputs, set in training
% * <numberOfOutputs_help.html |numberOfOutputs|> - (1 x 1) number of all physical outputs, set in training
%
%
%% Local Model Properties
%
% *LOLIMOT*
%
% * <center_help.html |center|> - (G x nz) center of the gaussian
% * <lowerLeftCorner_help.html |lowerLeftCorner|> - (G x nz) lower left corner of the rectangle surrounding the gaussian
% * <localLossFunctionValue_help.html |localLossFunctionValue|> - (1 x 1) local loss function value
% * <standardDeviation_help.html |standardDeviation|> - (G x nz) standard deviations of all gaussians
% * <upperRightCorner_help.html |upperRightCorner|> - (G x nz) upper right corner of the rectangle surrounding the gaussian
% * <parameter_help.html |parameter|> - (nx x 1) parameter of the local model
% * <zLowerBound_help.html |zLowerBound|> - (1 x nz) lower boundary of the training data
% * <zUpperBound_help.html |zUpperBound|> - (1 x nz) upper boundary of the training data
%
% *HILOMOT*
%
% * <center_help.html |center|> - (1 x nz)    vector of the center coordinates
% * <parameter_help.html |parameter|> - (nx x q)    vector/matrix of local model parameters
% * <localLossFunctionValue_help.html |localLossFunctionValue|> - (scalar) the local loss function value
% * <parent_help.html |parent|> - (scalar)    index of parent knot
% * <children_help.html |children|> - (1 x ?)     indices of children knots
% * <splittingParameter_help.html |splittingParameter|> - (nz+1 x 1) parameter of the sigmoid
% * <localSmoothness_help.html |localSmoothness|> - (scalar)  smoothness parameter
% * <pseudoInv_help.html |pseudoInv|> - 
%
%% Data Set Information Properties
%
% * <inputDescription_help.html |inputDescription|> - 
% * <outputDescription_help.html |outputDescription|> - 
% * <dataSetDescription_help.html |dataSetDescription|> - 
% * <samplingTime_help.html |samplingTime|> - 
%
%
%% History Properties
%
%
% * <currentNumberOfParameters_help.html |currentNumberOfParameters|> -	(1 x iter) Overall number of model parameters for each iteration
% * <currentNumberOfEffParameters_help.html |currentNumberOfEffParameters|> -	(1 x iter) Effective number of model parameters for each iteration
% * <currentNumberOfLMs_help.html |currentNumberOfLMs|> -	(1 x iter) Overall number of models for each iteration
% * <globalLossFunction_help.html |globalLossFunction|> -	(1 x iter) Loss function values for the overall model
% * <penaltyLossFunction_help.html |penaltyLossFunction|> -	(1 x iter) Complexity penalized loss function values
% * <CVLossFunction_help.html |CVLossFunction|> -
% * <splitLM_help.html |splitLM|> -	(iter-1 x 1) History of LMs which are split
% * <splitDimension_help.html |splitDimension|> -	(iter-1 x 1) History of dimensions of the split
% * <splitRatio_help.html |splitRatio|> -	(iter-1 x 1) History of ratio of the split
% * <leafModelIter_help.html |leafModelIter|> -	(1 x iter) History of the active models per iteration
% * <trainingTime_help.html |trainingTime|> -	(1 x iter) Overall Training time up to this iteration
% * <displayMode_help.html |displayMode|> -	(logical) Flag to de-/activate printouts to the command window during training
% * <iteration_help.html |iteration|> -	(1 x 1) Stores the number of the used iteration
% * <validationDataLossFunction_help.html |validationDataLossFunction|> -	(1 x iter) Validation data loss function values for the overall model
% * <testDataLossFunction_help.html |testDataLossFunction|> -	(1 x iter) Test data loss function values for the overall model
%
%
%% Algorithm Specific Properties
%
% *LOLIMOT*
%
% * <numberOfLMReliable_help.html |numberOfLMReliable|> - (1 x 1)           Number of LMs for a reliable model estimation
% * <suggestedNet_help.html |suggestedNet|> - (1 x 1)           Suggested net with best performance/complexity trade-off
% * <idxAllowedLM_help.html |idxAllowedLM|> - (1 x M)           Stores the allowed local models with respect to splitting
% * <splits_help.html |splits|> - (1 x 1)           Number of splits tested in each dimension
% * <outputModel_help.html |outputModel|> - (N x q)           Model outputs
% * <xRegressor_help.html |xRegressor|> - (N x nx)          Regression matrix/Regressors for rule consequents
% * <zRegressor_help.html |zRegressor|> - (N x nz)          Regression matrix/Regressors for rule premises
% * <MSFValue_help.html |MSFValue|> - (1 x M)           Membership function values for each local model
%
%
% *HILOMOT*
%
% * <oblique_help.html |oblique|> - logical   0: axes-orthogonal partitioning, 1: axis-oblique partitioning
% * <numberOfPoints_help.html |numberOfPoints|> - (1 x 1)   Minimum number of points that have to be in a LM before it is allowed for splitting
% * <optGrad_help.html |optGrad|> - logical   0: numerical gradient, 1: analytical gradient
% * <optLOOCV_help.html |optLOOCV|> - logical   If true, split opt. w.r.t. LOO cross val. error
% * <suggestedNet_help.html |suggestedNet|> - (1 x 1)   Suggested net with best performance/complexity trade-off
% * <inputSensitivity_help.html |inputSensitivity|> - (nz x 1)  Sensitivity analysis of zRegressor-inputs. Value 1 has highest importance, value 0 seems to be a redundant input.
% * <outputModel_help.html |outputModel|> - (N x q)   Model outputs
% * <xRegressor_help.html |xRegressor|> - (N x nx)  Regression matrix/Regressors for rule consequents
% * <zRegressor_help.html |zRegressor|> - (N x nz)  Regression matrix/Regressors for rule premises
% * <phi_help.html |phi|> - (N x M)   Validity function matrix
%
%% SYMBOLS AND ABBREVIATIONS
%
% LM:  Local model
%
% p:   Number of inputs (physical inputs)
%
% q:   Number of outputs
%
% N:   Number of data samples
%
% M:   Number of LMs
%
% nx:  Number of regressors (x)
%
% nz:  Number of regressors (z)

% * <_help.html ||> - 
