% lolimotDemo2 Demo 2. Static process with 2 inputs and 1 output

% LoLiMoT - Nonlinear System Identification Toolbox
% Torsten Fischer, 20-October-2011
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles


% Training
lolimotObject = lolimot;                   % initialize lolimot object

[u1g u2g] = meshgrid(linspace(0,1,25), linspace(0,1,25));
u1 = u1g(:);
u2 = u2g(:);
y = 1./(0.1+u1) + (2*u2).^2;
lolimotObject.input = [u1 u2];
lolimotObject.output = y;

lolimotObject.maxNumberOfLM = 20;                           % Termination criterion for maximal number of LLMs
lolimotObject.minError = 0.03;                              % Termination criterion for minimal error
lolimotObject.kStepPrediction = 0;                          % Static model
lolimotObject.history.displayMode = true;                   % display information

% Train net object
lolimotObject = lolimotObject.train;

% Find best performance/complexity trade-off
[~, idxBest] = min(lolimotObject.history.penaltyLossFunction);
lolimotObject.leafModels = lolimotObject.history.leafModelIter{idxBest};

% Simulate net
[u1G u2G] = meshgrid(linspace(0,1,30), linspace(0,1,30));
u1G = u1G(:);
u2G = u2G(:);
yG = 1./(0.1+u1G) + (2*u2G).^2;
yGModel = calculateModelOutput(lolimotObject, [u1G u2G], yG);
JG = calcGlobalLossFunction(lolimotObject ,yG, yGModel);

figure
lolimotObject.plotModel

figure
lolimotObject.plotPartition