% lolimotDemo3 Demo 3. Static process with 2 inputs and 2 outputs

% LoLiMoT - Nonlinear System Identification Toolbox
% Torsten Fischer, 20-October-2011
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles


% Training
lolimotObject = lolimot;                   % initialize lolimot object

% Generate training data
[u1g u2g] = meshgrid(linspace(0,1,25), linspace(0,1,25));
u1 = u1g(:);
u2 = u2g(:);
y1 = 1./(0.1+u1) + (2*u2).^2;
y2 = u1.*u2;
lolimotObject.input = [u1 u2];
lolimotObject.output = [y1, y2];

lolimotObject.maxNumberOfLM = 15;           % Termination criterion for maximal number of LLMs
lolimotObject.minError = 0.05;              % Termination criterion for minimal error
lolimotObject.kStepPrediction = 0;          % Static model
lolimotObject.history.displayMode = true;   % display information

lolimotObject.xRegressorDegree = 1;         % use 1st order polynoms for local models

% Train net object
lolimotObject = lolimotObject.train;

% Find best performance/complexity trade-off
[~, idxBest] = min(lolimotObject.history.penaltyLossFunction);
lolimotObject.leafModels = lolimotObject.history.leafModelIter{idxBest};

lolimotObject = lolimotObject.estimateModelGlobal;

% Generalization
[u1G u2G] = meshgrid(linspace(0,1,30), linspace(0,1,30));
u1G = u1G(:);
u2G = u2G(:);
y1G = 1./(0.1+u1G) + (2*u2G).^2;
y2G = u1G.*u2G;

% Simulate net
yGModel = calculateModelOutput(lolimotObject, [u1G u2G], [y1G y2G]);
JG = calcGlobalLossFunction(lolimotObject, [y1G y2G], yGModel);

figure
lolimotObject.plotModel([1 2],1)

figure
lolimotObject.plotModel([1 2],2)


figure
lolimotObject.plotPartition