% DEMOHILOMOTCLASS demonstrates the functioning of the HILOMOT toolbox for a nonlinear
% static regression example.

% HILOMOTDOE Nonlinear System Identification Toolbox for Design of Experiments
% Benjamin Hartmann, 25-November-2011
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2011 by Prof. Dr.-Ing. Oliver Nelles


% clear all
clear
close all
clc
% clear java


example = 'hyperbel';

% Train input & output
% rng(33,'twister')
input = rand(35,2);
u1 = input(:,1); u2 = input(:,2);
y = demoFunctions(input, example)+ 0.0*randn(size(u1));
data = [input y];


% Test input
[u1g u2g] = meshgrid(linspace(0,1,25));
u1Test = u1g(:);
u2Test = u2g(:);
testInput = [u1Test u2Test];
yTest = demoFunctions(testInput, example);

% load auto_mpg_data
% testInput = data(:,1:end-1);


% Training
[AllLMN alpha YMtrain trainRMSE] = modelByCommittee(data);

% Evaluate model committee on test data
YMtest = evalModelByCommittee(testInput, AllLMN, alpha);

% Set query
[query maxIdx] = queryByCommittee(testInput, AllLMN, alpha);


figure(13)
clf
plot3(u1,u2,y,'rx','markersize',12,'linewidth',3)
hold on
grid on
surf(u1g,u2g,reshape(YMtest,25,25));
legend('data','model by committee')
for k = 1:length(alpha)
    h = mesh(u1g,u2g,reshape(AllLMN{2,k}.calculateModelOutput(testInput),25,25));
    set(h,'facecolor','none')
    hold on
    pause(0.5)
end

% % Query by Committee
% mittelwert = mean(YM,2);
% varVec = 1/(length(alpha)-1)*sum((YM-mittelwert(:,ones(length(alpha),1))).^2,2);
% % varVec = var(YM,0,2);
% [~, maxIdx]  = max(varVec);
% query = testInput(maxIdx,:);


plot3(query(1),query(2),YMtest(maxIdx),'ko','markersize',14,'linewidth',2)
% plot3(u1Test,u2Test,YMtest,'r.','markersize',14,'linewidth',2)


% figure
% AllLMN{2,1}.plotPartition