function out = combinations(inputVector,subsetSize)
% Function determines all possible combinations of the inputVector with the
% given subsetSize.
%
% function out = combinations(inputVector,subsetSize)
%
% INPUTS
%
% inputVector:          Vector containing all individuals
% subsetSize:           Integer, that determines the length of one
%                       combination
%
% OUTPUTS
%
% out:                  nc x ns Matrix; Every line contains one possible
%                       combination.
%
% nc: Number of all possible combinations
% ns: Value equals the variable subsetSize

% Julian Belz, 30-April-2012
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles

if nargin < 2
    error('Input arguments are missing!');
end

% Make sure inputVektor is a colum vektor
if size(inputVector,2) ~= 1
    inputVector = inputVector';
end

% Make sure inputVektor is no matrix
if size(inputVector,2) ~= 1
    error('First input argument must be a vector!');
end

% Make sure subsetSize is a scalar
if size(subsetSize,1) ~= 1 || size(subsetSize,2) ~= 1 || length(size(subsetSize)) > 2
    error('Second input argument must be a scalar!');
end

% Make sure subsetSize is of type integer (Note: The maximum value of
% subsetSize is limited to 255)
% subsetSize = uint8(subsetSize);

if subsetSize == size(inputVector,1)
    % If the size of the inputVector and subsetSize is equal, there is only
    % one possible combination, which is inputVector.
    out = inputVector';
elseif subsetSize == 1
    % If subsetSize equals one, the inputVector contains all
    % size(inputVector,1) possible combinations
    out = inputVector;
else
    % Recursive part; Function is called until one of the upper conditions
    % is met. After that all other values can be calculated.
    out = [];
    for ii=1:size(inputVector,1)-subsetSize+1
        tmpOut = sensitivityAnalysis.combinations(inputVector(ii+1:end),subsetSize-1);
        out = [out; inputVector(ii)*ones(size(tmpOut,1),1) tmpOut];
    end
end
    

end