function abbreviation = determineAbbreviation(inputCombinationVector)
% Create and save abbreviation for the input combination vector
% -[5] --> Only input five is removed from all possible inputs
% +[5] --> Only input five is used
% -[] --> All inputs are used/no input is removed
if sum(inputCombinationVector,2) < (size(inputCombinationVector,2)/2)
    colums1 = find(inputCombinationVector);
    str1 = sensitivityAnalysis.makeDesignationString(colums1); %#ok<FNDSB>
    abbreviation = ['+[',str1,']'];
else
    colums1 = find(inputCombinationVector==0);
    str1 = sensitivityAnalysis.makeDesignationString(colums1); %#ok<FNDSB>
    abbreviation = ['-[',str1,']'];
end
end