%% Example to emphase the abilities of the z-input selection

% Visualization Options
linewidth = 1.5;
colorX = [0 0 0];
colorZ = [0 0 0];

% Function definitions
fun_u1 = @(x) 0.2./(0.2+(1-x));
fun_u2 = @(x) exp(-(0.5-x).^2/0.5^2);
fun_u3 = @(x) 0.8*x;
fun_u4 = @(x) 0.05*randn(size(x));
y = @(x) fun_u1(x(:,1))+fun_u2(x(:,2))+fun_u3(x(:,3))+fun_u4(x(:,4));

% Create Training data
noTrainData = 9^4;
uAxis = linspace(0,1,(noTrainData)^(1/4))';
uTrain = makeBenchInputND(4,uAxis);
yTrain = y(uTrain);

% Create Test data
duAxis = diff(uAxis(1:2));
uAxisTest = uAxis(1:end-1)+duAxis/2;
uTest = makeBenchInputND(4,uAxisTest);
yTest = y(uTest);

% Sensitivity Analysis object for x input selection
lmn = sensitivityAnalysis;
lmn.input = uTrain;
lmn.output = yTrain;
lmn.space2investigate = 'x';

% Pass validation data
% lmn.maxPenaltyDeterioration = inf;
lmn.validationInput = uTest;
lmn.validationOutput = yTest;

% Sensitivity Analysis object for z input selection
lmnZ = lmn;
lmnZ.space2investigate = 'z';

% Perform selection algorithms
lmnZ = lmnZ.findInputCombinations('forwardSelection');
lmn = lmn.findInputCombinations('forwardSelection');

% lmnZ = lmnZ.findInputCombinations('bruteForce');
% lmn = lmn.findInputCombinations('bruteForce');

% 
fhZ = figure;
ahZ = axes;

fhX = figure;
ahX = axes;

hLineZ=lmnZ.visualizeAICoverNumberOfInputs(ahZ,[],[],fhZ);
hLineX=lmn.visualizeAICoverNumberOfInputs(ahX,[],[],fhX);

set([hLineZ{:}],'Color',colorZ);
set([hLineX{:}],'Color',colorX);

