%%
pointsPerAxis   = 31;
uAxis           = linspace(0,1,pointsPerAxis)';
U               = makeBenchInputND(2,uAxis);
yUndisturbed    = benchFunktionND(U,'hyperbel');

u1g             = reshape(U(:,1),pointsPerAxis,pointsPerAxis);
u2g             = reshape(U(:,2),pointsPerAxis,pointsPerAxis);
yUndisturbedG   = reshape(yUndisturbed,pointsPerAxis,pointsPerAxis);

figure;
ah = axes;
surf(ah,u1g,u2g,yUndisturbedG);

hx = xlabel(ah,'u_1');
hy = ylabel(ah,'u_2');
hz = zlabel(ah,'y');
ht = title(ah,'Hyperbel 45/45');
set(hz,'Rotation',0);
set(ah,'ZTick',[0 1]);

set([ah,hx,hy,hz,ht],'FontName','Arial','FontSize',30);

pointsPerAxis   = 41;
uAxis           = linspace(0,1,pointsPerAxis)';
U               = makeBenchInputND(1,uAxis);
yUndisturbed    = benchFunktionND(U,'hyperbel');

figure;
ah = axes;
plot(U,yUndisturbed,'LineWidth',4,'Color',[0 0 0]);

hx = xlabel(ah,'u_1');
hy = ylabel(ah,'y');
ht = title(ah,'Hyperbel');
set(hy,'Rotation',0);
set(ah,'YTick',[0 1]);


set([ah,hx,hy,ht],'FontName','Arial','FontSize',30);