function regressor = data2zRegressor(obj, input, output)
% "data2zRegressor" is used to build the z-Regressor matrix depending on the
% number of inputs and outputs and their delays. In the z-Regressor matrix
% the offset is not intended. If a polynomial trial function is used its
% degree must be one.
%
% regressor = data2zRegressor(obj, input, output)
%
% Input:
%   obj         object      regressor object containing all relevant
%                           information and variables
%   input       (N x p)     data matrix containing physical inputs
%   output      (N x q)     data matrix containing physical outputs (optional)
%
% Output:
%   regressor   (N x nx)    regression matrix containing inputs
%                           (and outputs if dynamic model)
%
%
% SYMBOLS AND ABBREVIATIONS
%
% LM:  Local model
%
% p:   Number of inputs (physical inputs)
% q:   Number of outputs
% N:   Number of data samples
% M:   Number of LMs
% nx:  Number of regressors (x)
% nz:  Number of regressors (z)

% LMNtool - Local Model Network Toolbox
% Tobias Ebert, 24-April-2012
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles

% 30.09.11 v0.1
% 04.10.11 v0.2
% 05.10.11 changed to new format
% 16.11.11 doc/help updated (TE)

if ~exist('output','var')
    % only inputs are used to assemble to regressor
    output = [];
end

% create datamatrix for regressor
if ~isempty(input) % test if an input is given
    if ~isempty(obj.zInputDelay)
        inputDelay = obj.zInputDelay; % use given delay
    else
        inputDelay = num2cell(zeros(1,size(input,2))); % use default delays
    end
else
    inputDelay = [];
end
if ~isempty(output) % test if an output is given
    if ~isempty(obj.zOutputDelay)
        outputDelay = obj.zOutputDelay; % use given delay
    else
        outputDelay = cell(1,size(output,2)); % use default delays
    end
else
    outputDelay = [];
end

% assemble all the delayed physical inputs and outputs to a data matrix
regressor = obj.delay2DataMatrix(input,output,inputDelay,outputDelay);

end

