% DEMOHILOMOTCLASS demonstrates the functioning of the HILOMOT toolbox for a nonlinear
% static regression example.

% HILOMOTDOE Nonlinear System Identification Toolbox for Design of Experiments
% Benjamin Hartmann, 25-November-2011
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2011 by Prof. Dr.-Ing. Oliver Nelles


clear all
clear
% close all
% clc
% clear java


% Initialize hilomot object
LMN = hilomot;
LMN.LOOCV = true;
% LMN.optLOOCV = true;
% LMN.scaleInput = [];


% User defined options
% LMN.minError = 0.05;
LMN.maxNumberOfLM = 10;
% LMN.maxNumberOfParameters = 100;
% LMN.optGrad = 1;
% LMN.smoothness = 0.1;
LMN.oblique = 1;
LMN.optLOOCV = 0;


% LMN.maxTrainTime = 5/60;
% LMN.complexityPenalty = 1;
LMN.maxPenaltyDeterioration = inf;

% LMN.lossFunctionGlobal = 'MSE';

LMN.xRegressorDegree = 2;


% Create training data:
% noiseLevel = 0.05;
% rng(18,'twister');
% [LMN.input, LMN.output, examplelStruct] = exampleFunctions(3, 1, 'grid', 30, noiseLevel);

% variance = (noiseLevel * (max(LMN.output)-min(LMN.output) )).^2;


% Create test data
% [LMN.testInput, LMN.testOutput] = exampleFunctions([], [], 'grid', 1000, noiseLevel, examplelStruct);

u = linspace(-1,1,30)';
% y = u.^3;
y = sin(3*u);

rng(23,'twister')
y = y + 0.2*rand(size(y,1),1);
% y(10) = 3;

LMN.input = u;
LMN.output = y;


% Train LMN object with hilomot class
tic
LMN = LMN.train;
toc



idxBest = LMN.suggestedNet;
LMNBest = LMN;
LMNBest.leafModels = LMN.history.leafModelIter{idxBest};


% Plot model vs. process and partitioning
% figure
% LMNBest.plotModel
% % options.plotMethod = 'contour';
% % figure; LMNBest.plotPartition([],[],options)
% figure; LMNBest.plotPartition
% 

figure(22)
hist((LMN.output-LMN.outputModel))





% M    = sum(LMN.leafModels);
% N    = size(LMN.input,1);
% AIC  = LMN.history.penaltyLossFunction;
% % AIC  = AIC(AIC<2);
% % TEST = LMN.history.testDataLossFunction;
% CVScoreIter = LMN.history.CVLossFunction;
% TRAIN = LMN.history.globalLossFunction;
% 
% % AIC = AIC(1:2)
% 
% figure
% hold on
% plot(1:M,TRAIN,'rx-')
% % plot(1:M,TEST,'rx-')
% plot(1:length(AIC),AIC,'b*-')
% plot(1:M,CVScoreIter,'kv-')
% % minVec = [min(TEST) min(AIC) min(CVScoreIter)];
% % maxVec = [max(TEST) max(AIC) max(CVScoreIter)];
% minVec = [min(AIC) min(CVScoreIter)];
% maxVec = [max(AIC) max(CVScoreIter)];
% axis([0 sum(LMN.leafModels) 0.9*min(minVec) 1.1*max(maxVec)])
% legend('TEST','AICc','CV')
% 
% 
% axis([0 M+1 0 1.5])
% 
% % Errorbars ausrechnen
% c = 1;
% NG = 100;
% uG = linspace(0.001,0.999,NG)';
% [errorbar df1 df2 estVar] = LMNBest.calcErrorbar(uG);
% yM = LMNBest.calculateModelOutput(uG);
% [~,maxidx] = max(errorbar);
% 
% 
% figure(12); 
% hold on
% 
% % f = [yM+c*errorbar; flipdim(yM-c*errorbar,1)];
% % h = fill([uG; flipdim(uG,1)], f, [7 7 7]/8);
% % set(h,'EdgeColor','None')
% 
% 
% plot(uG,yM,'k')
% plot(LMN.input,LMN.output,'r-','markersize',12)
% 
% 
% plot(uG,yM+c*errorbar,'k--')
% plot(uG,yM-c*errorbar,'k--')
% plot(uG(maxidx),yM(maxidx),'bo','markersize',12)
% line([uG(maxidx) uG(maxidx)],[min(yM(maxidx)-c*errorbar(maxidx)) max(yM(maxidx)+c*errorbar(maxidx))])



% XReg = LMNBest.xRegressor;
% errorValue = LMNBest.output-LMNBest.outputModel;
% inputReg = [ones(size(uG,1),1) uG];
% lmIdx = find(LMNBest.leafModels);
% errorbar2=zeros(NG,1);
% for k = 1:length(lmIdx)
%     
%     lm = lmIdx(k);
%     Q = diag(LMN.phi(:,lm));
%     [delta] = modCalcCI(XReg,inputReg,errorValue,Q);
%     
%     phiG = LMNBest.calculatePhi(uG,lm);
%     
%     errorbar2 = errorbar2 + phiG.*delta;
% end
% 
% figure(12);
% hold on
% plot(uG,yM+c*errorbar2,'b')
% plot(uG,yM-c*errorbar2,'b')
