function [query maxIdx] = queryByCommittee(candidates, AllLMN, alpha)

% Select a point (i.e. a row of candidates) with maximum variance of model committee members given by AllLMN and alpha.

% AllLMN:      Cell containing all committee members trained by modelByCommittee.m
% candidates:  Candidate inputs [u1,u2,...,up] to calculate model output y. Dimension (N x p).

% Evaluate model for new data
N = size(candidates,1);
nCom = length(alpha);
Y = zeros(N,nCom);
for k = 1:nCom
    Y(:,k) = AllLMN{2,k}.calculateModelOutput(candidates);
end

% Calculate variance of committee on candidate points
Ymean = mean(Y,2);
Ymean = Ymean(:,ones(nCom,1));
varVec = 1/(nCom-1)*sum((Y-Ymean).^2,2);

% Select candidate with maximum variance
[~, maxIdx]  = max(varVec);
query = candidates(maxIdx,:);
