%% Reactivation

clear; clear all; close all; clc;

% Define discrete values in the input space to evaluate the membership
% functions and the normalized membership functions
u = linspace(-2,3,1001)';

% Define center and standard deviations for the membership functions
c = [-0.7 0.5 1.7];
sigma = [0.5 0.5 0.5];

% Define three membership functions
g1 = @(input) exp(-((input-c(1))./sigma(1)).^2);
g2 = @(input) exp(-((input-c(2))./sigma(2)).^2);
g3 = @(input) exp(-((input-c(3))./sigma(3)).^2);

% Determine position of the plots
scrsize = get(0,'ScreenSize');
width = 400;
height = 400;
pos1 = [(scrsize(3)-width)/2 (scrsize(4)-height)/2 width height];
pos2 = pos1 + [width 0 0 0];
linewidth = 4;

% Visualize the membership functions
fh1 = figure('Position',pos1);
ah1 = axes;

plot(ah1,u,[g1(u) g2(u) g3(u)],'LineWidth',linewidth);

hx1 = xlabel(ah1,'u');
hy1 = ylabel(ah1,'\mu_i');
ht1 = title(ah1,'Teilungsfunktionen');


% Visualize normalized membership functions
fh2 = figure('Position',pos2);
ah2 = axes;

denominator = g1(u)+g2(u)+g3(u);
g1n = g1(u)./denominator;
g2n = g2(u)./denominator;
g3n = g3(u)./denominator;

plot(ah2,u,[g1n g2n g3n],'LineWidth',linewidth);

hx2 = xlabel(ah2,'u');
hy2 = ylabel(ah2,'\Phi_i');
ht2 = title(ah2,'Gltigkeitsfunktionen (Fuzzy)');

set([ah1,ah2],'XLim',[-2 3],'YLim',[-0.05 1.05])

set([hx1,hx2,hy1,hy2,ht1,ht2,ah1,ah2],'FontSize',24,'FontName','Arial');