function [model,input,output] = selectDataAndTrainModel(combinationVector,netz)
% This function is used for at least three strategies in the same
% way to determine which points from the original input (with all
% possible inputs) is needed for just a few inputs
%
% [model, input, output] = selectData(combinationVector)
%
% INPUTS
%
% combinationVector:        [1 x p] Logicals that determine which
%                                   input should be used and which
%                                   one should be neglected
%
% OUTPUTS
%
% input:                    [Nf x pf] Every line contains one data
%                                     point. pf is the current
%                                     input dimensionality. Because
%                                     of the reduced number of
%                                     inputs, many points of the
%                                     original input data might be
%                                     redundant so that Nf is the
%                                     number of unique input
%                                     combinations for the current
%                                     input dimensionality
%
% output:                   [Nf x 1] Corresponding output value to
%                                    every data point in the input
%                                    matrix
%
% model:                    [1 x 1] hilomot-object

% Create new variable containing the model-object
model = netz;

switch netz.space2investigate
    % Only two cases can occur: 'x' or 'z'. This is guaranteed
    % through a set method in the sensitivityAnalysis class
    % definition
    case 'x'
        
        % At first select only desired inputs, that are determined by one
        % combinationVector
        input = netz.originalInput(:,combinationVector);
        
        % Select the corresponding outputs
        output = netz.originalOutput;
        
        % Delete former training data
        model.input = [];
        model.output = [];
        % In- and output scaling has to be deleted, to guarantee that the
        % number of parameters is equal to the number of inputs
        if ~isempty(model.scaleInput)
            scaleMethod = model.scaleInput.method;
            model.scaleInput = [];
            model.inputScalingComplete = false;
            model.scaleInput = scaleData;
            model.scaleInput.method = scaleMethod;
        end
        if ~isempty(model.scaleOutput)
            scaleMethod = model.scaleOutput.method;
            model.scaleOutput = [];
            model.outputScalingComplete = false;
            model.scaleOutput = scaleData;
            model.scaleOutput.method = scaleMethod;
        end
        
        % If a certain subset in the z-space is chosen, make sure that the
        % restrictions maintain.
        if ~isempty(model.zInputDelay)
            model.zInputDelay = model.zInputDelay(combinationVector);
        end
        
        % If there is validation data available, make sure only the chosen
        % inputs are used
        if ~isempty(model.validationInput)
            model.validationInput = model.validationInput(:,combinationVector);
        end
        
        % Pass new in- and outputs to the lmn and train afterwards
        model.input = input;
        model.output = output;
        
    case 'z'
        
        % So far only for static systems!!
        model.zInputDelay = num2cell(zeros(1,size(combinationVector,2)));
        model.zInputDelay(~combinationVector) = {[]};
        
end



% Delete possibly earlier performed training
model.sensitivityResults = [];
model.history         = modelHistory;
model.leafModels      = [];
model.localModels     = [];
model.outputModel     = [];
model.xRegressor      = [];
model.zRegressor      = [];
model.phi = [];
model.testInput = [];
model.testOutput = [];
% model.validationInput = [];
% model.validationOutput = [];

% If there are no directions, where splitting is allowed, set the
% maximum number of local models to one to prevent errors
if iscell(model.zInputDelay) && isempty(cell2mat(model.zInputDelay))
    model.maxNumberOfLM = 1;
    model.zInputDelay = num2cell(zeros(1,size(model.combinationMatrix,2)));
end

% If the x-space should be investigated, the case where no inputs are
% selected leads to an empty input property of the model
if isempty(model.input)
    % If there is no input, no training can be performed and model is
    % passed back empty.
    model = [];
else
    
    fprintf(['Training with input subset (',netz.space2investigate,...
        '-space investigation): [',num2str(find(combinationVector)),'] \n \n']);
    
    % Train with new input subset
    model = model.train;
    
    % Make sure the suggested net is chosen
    model.leafModels = model.history.leafModelIter{model.suggestedNet};
end

end