function [uG] = makeBenchInputND(inputDim, achsteilung)
%
% Programm erzeugt eine Matrix [AnzahlMesspunkte]x[Eingangsraumdimension],
% die zur Eingabe in das Programm 'benchFunktionND.m' dient. Darin sind
% alle Messpunkte enthalten (jede Zeile entspricht einem Messpunkt).
%
% function [uG] = makeBenchInputND(inputDim, achsteilung)
%
% inputs
%
% inputDim      : Dimension des Eingangsraumes [1x1]
% achsteilung   : Teilung einer Achse/Dimension (alle Achsen bzw.
%                 Dimensionen werden gleich geteilt)
%                 Vektor: [Anzahl Messstellen innerhalb einer Dimension]x[1]
%
% outputs
%
% uG            : Ausgabematrix, in dessen Zeilen die jeweiligen Messpunkte
%                 stehen [AnzahlMesspunkte]x[Eingangsraumdimension]
%
 

if inputDim == 1
    % Fr einen Eingangsraum mit einem Eingang entspricht die achsteilung
    % bereits dem gewnschtem Ergebnis
    uG = achsteilung;
else
    
    % Cell zur Aufnahme der Arrays aus ndgrid (1. Zeile der Cell) und der
    % daraus erzeugten stehenden Vektoren (2. Zeile der Cell)
    ug = cell(2,inputDim);
    
    % Vorabdefinition des Strings, der ausgefhrt wird, um mit dem Befehl
    % ndgrid die einzelnen Arrays zu erzeugen
    ugstr = '[';
    
    % Vordefinition des Strings in dem die Namen der Eingangsvariablen fr den
    % Befehl ndgrid stehen
    uIn = [];
    
    % Schleife zur Erstellung des Strings, dessen Ausfhrung mit dem Befehl
    % eval das ndgrid erzeugt
    for ii = 1:inputDim
        ugstr = [ugstr,'ug{1,',int2str(ii),'} ']; %#ok<AGROW>
        uIn = [uIn,'achsteilung,'];               %#ok<AGROW>
    end
    
    % Erzeugung des ndgrids
    ugstr = [ugstr(1:end-1),'] = ndgrid(',uIn(1:end-1),');'];
    eval(ugstr);
    
    % Erzeugen der Ausgabematrix
    for ii = 1:inputDim
        ug{2,ii} = ug{1,ii}(:);
    end
    uG = [ug{2,:}];
end