%% Hyperbel Ebene

clear; clear all; close all; clc;

%% Define Process and 'measured' training data
inputDimension  = 2;
exampleFunction = 'hyperbel';

hypFnc          = @(u) benchFunktionND(u,exampleFunction);
LinFnc          = @(u) 0.8*u;

pointsPerAxis   = 31;
uAxis           = linspace(0,1,pointsPerAxis)';
U               = makeBenchInputND(inputDimension,uAxis);

% Only necessary for two dimensional inputs
u1g             = reshape(U(:,1),pointsPerAxis,pointsPerAxis);
u2g             = reshape(U(:,2),pointsPerAxis,pointsPerAxis);

% Create Process output
processFcn      = @(input) hypFnc(input(:,1)) + LinFnc(input(:,2));

y               = processFcn(U);
yG              = reshape(y,pointsPerAxis,pointsPerAxis);

prozessAusgaenge= {yG,yG};
bezeichnung     = {'Surf Plot','Contour Plot'};

%% Plot options
scrsize         = get(0,'ScreenSize');
width           = 800;
height          = 500;
pos             = [(scrsize(3)-width)/2 (scrsize(4)-height)/2 width height];
linewidth       = 2;
fontname        = 'Arial';
fontsize        = 14;

figure('Position',pos);
ah              = cell(1,2);

%% Visualisierung
for ii=1:2
    
    ah{ii} = subplot(1,2,ii);
    if ii<2
        surf(ah{ii},u1g,u2g,prozessAusgaenge{ii});
    else
        contour(ah{ii},u1g,u2g,prozessAusgaenge{ii});
    end
    
    ht = title(ah{ii},bezeichnung{ii});
    hx = xlabel(ah{ii},'u_1');
    hy = ylabel(ah{ii},'u_2');
    hz = zlabel(ah{ii},'y');
    
    set([hx,hy,hz,ht,ah{ii}],'FontName',fontname,'FontSize',fontsize);
    
end
