classdef functionVisualization < dataSet
    % This class helps to visualize simple functions in the GUIvisualize
    % interface
    %
    % Some more explanation
    %
    % PROPERTIES
    %
    % functionHandle:       String of an external m-file, that is
    %                       evaluated in 'calculateModelOutput'
    %
    
    % Julian Belz, 02-July-2012
    % Institut fr Mess- und Regelungstechnik, Universitt Siegen, Deutschland
    % Institute of Measurement and Control, University of Siegen, Germany
    % Copyright (c) 2011 by Oliver Nelles
    
    properties
        functionHandle = []
    end
    
    methods
        
        %% Constructor
        function fV = functionVisualization(funktion)
            if nargin < 1
                % If no functionHandle is passed, just square all inputs
                fV.functionHandle = @(u)u.^2;
            elseif nargin > 1
                error('Too many inputs!');
            else
                eval(['fV.functionHandle = @',funktion,';']);
            end
        end
        
        outputModel = calculateModelOutput(obj, input, output)
    end
end