function [flag,showWarning] = crossValidationWarning
% Small GUI to let the user decide, if the time consuming
% cross validation really should be calculated

% some constants
scrsize         = get(0,'screensize');
bgcolor         = [0.7 0.7 0.7];
FSueber         = 15; % Schriftgroesse Ueberschriften
FNueber         = 'Times New Roman'; % Schriftart Ueberschriften
fontsize        = 13;
fontname        = 'Times New Roman';
xpos            = 10;
bodywidth       = 380;
hdistance       = 10;
hueberschr      = 25;
htext           = 70;
buttonheight    = 25;
buttonwidth     = 100;
fhwWidth        = 400;
fhwHeight       = 150;
fhwPosition     = [(scrsize(3) - fhwWidth)/2 ...
    (scrsize(4) - fhwHeight)/2 ...
    fhwWidth ...
    fhwHeight];

% make figure
fhw = figure('Visible','off',...
    'Position',fhwPosition,...
    'MenuBar','none',...
    'Toolbar','figure',...
    'Color',bgcolor);

% GUI components
htextcell{1,1} = uicontrol('Parent',fhw,...
    'Style','text',...
    'Position',[xpos fhwHeight-25 bodywidth 25],...
    'String','Warning',...
    'HorizontalAlignment','center',...
    'FontName',FNueber,...
    'FontSize',FSueber);

htextcell{2,1} = uicontrol('Parent',fhw,...
    'Style','text',...
    'Position',[xpos,...
    fhwHeight-hueberschr-hdistance-htext, bodywidth,...
    htext],...
    'String',['Remind that the calculation of the ',...
    'cross validation errors (that are needed for ',...
    'any PRESS criteria) may take a lot of time. ',...
    'Do you really want to continue?'],...
    'HorizontalAlignment','left',...
    'FontName',fontname,...
    'FontSize',fontsize);

lineheight = ...
    fhwHeight-hueberschr-2*hdistance-htext-buttonheight;

yesButton = uicontrol('Parent',fhw,...
    'Style','pushbutton',...
    'Position',[xpos,lineheight, ...
    buttonwidth, buttonheight],...
    'String','Yes',...
    'Callback',@getFlag);

noButton = uicontrol('Parent',fhw,...
    'Style','pushbutton',...
    'Position',[xpos+buttonwidth+10,lineheight, ...
    buttonwidth, buttonheight],...
    'String','No',...
    'Callback',@getFlag);

hcb = uicontrol(fhw,...
    'Style','checkbox',...
    'String','Do not show this warning again',...
    'Value',1,...
    'Position',[xpos+2*buttonwidth+20,lineheight,...
    175, 25]);

set(fhw,'Visible','on')

% GUI functions

    function getFlag(hObject,eventdata)
        size(eventdata);
        % determine, if this warning should show up again
        cbValue = get(hcb,'Value');
        if cbValue
            showWarning = 0;
        else
            showWarning = 1;
        end
        
        % set output of the GUI
        if hObject == yesButton
            flag = 1;
        elseif hObject == noButton
            flag = 0;
        end
        
        % close figure
        close(fhw);
    end

waitfor(fhw);
end