function exportFigure(hObject,eventdata,obj)
size(hObject);
size(eventdata);
if isempty(obj.dataSet)
    return;
else
    figure;
    ax1 = axes;
    plotInputDim = get(obj.hPopDim,'Value');
    inColum1     = get(obj.hPlotu1,'Value');
    inColum2     = get(obj.hPlotu2,'Value');
    outColum     = get(obj.hPloty,'Value');
    xBeschr      = get(obj.hPlotu1,'String');
    xBeschr      = xBeschr{inColum1};
    yBeschr      = get(obj.hPlotu1,'String');
    yBeschr      = yBeschr{inColum2};
    zBeschr      = get(obj.hPloty,'String');
    zBeschr      = zBeschr{outColum};
    
    axChild = get(obj.ha,'Children');
    % Falls Trainingsdaten mit angezeigt werden, besitzt
    % die axes zwei Kind-Elemente
    if length(axChild) > 1
        plotInfo  = get(axChild(2));
        plotInfo2 = get(axChild(1));
        if size(plotInfo2.XData,1) == ...
                size(plotInfo2.XData,2)
            tmp = plotInfo;
            plotInfo  = plotInfo2;
            plotInfo2 = tmp;
        end
    else
        plotInfo = get(axChild(1));
    end
    if plotInputDim == 1
        xlim = get(obj.ha,'XLim');
        ylim = get(obj.ha,'YLim');
        
        plot(ax1,plotInfo.XData,plotInfo.YData,...
            'LineStyle',obj.linestyle,'Marker',obj.marker,...
            'MarkerSize',obj.markersize,...
            'LineWidth',obj.linewidth);
        
        if exist('plotInfo2','var')
            hold(ax1,'on');
            
            plot(ax1,plotInfo2.XData,plotInfo2.YData,...
                'LineWidth',obj.linewidth,'LineStyle',obj.linestyle,...
                'Marker',obj.marker,'MarkerSize',obj.markersize,...
                'color',obj.tdpointColor);
            
            hold(ax1,'off');
        end
        
        set(ax1,'XLim',xlim,'YLim',ylim);
        hx = xlabel(ax1,xBeschr);
        hy = ylabel(ax1,zBeschr);
        set([hx,hy,ax1],'FontName',obj.fontname,...
            'FontSize',obj.fontsize);
    else
        noDar       = get(obj.hPopDarstellung,'Value');
        darstellung = get(obj.hPopDarstellung,'String');
        darstellung = darstellung{noDar};
        camPos      = get(obj.ha,'CameraPosition');
        
        switch darstellung
            case 'plot3'
                set(gcf,'CurrentAxes',ax1);
                plot3(plotInfo.XData,plotInfo.YData,...
                    plotInfo.ZData,...
                    'LineWidth',obj.linewidth,...
                    'LineStyle',obj.linestyle,...
                    'Marker',obj.marker,...
                    'MarkerSize',obj.markersize)
            case 'mesh'
                hmesh=mesh(ax1,plotInfo.XData,...
                    plotInfo.YData,...
                    plotInfo.ZData);
                set(hmesh,'FaceColor','none');
            case 'surf'
                surf(ax1,plotInfo.XData,...
                    plotInfo.YData,...
                    plotInfo.ZData);
        end
        
        if exist('plotInfo2','var')
            hold(ax1,'on');
            set(gcf,'CurrentAxes',ax1);
            plot3(plotInfo2.XData,plotInfo2.YData,...
                plotInfo2.ZData,...
                'LineWidth',obj.linewidth,'LineStyle',obj.linestyle,...
                'Marker',obj.marker,'MarkerSize',obj.markersize,...
                'color',obj.tdpointColor);
            hold(ax1,'off');
        end
        
        hx = xlabel(ax1,xBeschr);
        hy = ylabel(ax1,yBeschr);
        hz = zlabel(ax1,zBeschr);
        
        set([hx,hy,hz,ax1],'FontName',obj.fontname,...
            'FontSize',obj.fontsize);
        set(ax1,'XGrid','on','YGrid','on','ZGrid','on',...
            'CameraPosition',camPos);
    end
end
end % end exportFigure