function yhat = calculateModelOutput(obj,input,output)
% SIMULATE calculates the output for a given input. You may also simulate
% a dynamic model
%
% yhat = simulate(obj,input,output)
%
% OUTPUTS:
%   yhat    (N x q) matrix of calculated outputs
%
% INPUTS:
%   input   (N x p) matrix of inputs
%   output  (N x q) (optional for dynamic models) matrix of outputs
%
% ABBREVIATIONS:
%   N:  number of samples
%   q:  number of physical outputs
%   p:  number of physical inputs

% Tobias Ebert, 11-Oct-2011
% Institut fr Mess- und Regelungstechnik, Universitt Siegen, Deutschland
% Institute of Measurement and Control, University of Siegen, Germany
% Copyright (c) 2011 by Tobias Ebert

if ~exist('input','var') && ~exist('output','var')
    yhat = obj.xRegressor*obj.localModels(obj.leafModels).parameter;
else
    if ~exist('output','var')
        output = [];
    end
    
    
    yhat = obj.data2xRegressor(input,output)*obj.localModels(obj.leafModels).parameter;
end


end