function queryNew = DoEFindNextIncrement(query, varInc)
% DOEFINDNEXTINCREMENT ensures that query points correspond to the variable increments that can be adjusted on the test bench.
%
%
% [queryNew] = DoEFindNextIncrement(query, varInc)
%
%
% INPUT
%
%   query:     ? x p    Current query points.
%   varInc:    struct   Delivers min, max and increment value for each input dimension.
%
%
% OUTPUT
%
%   queryNew:  ? x p    New query points.
%
%
% HiLoMoTDoE - Nonlinear System Identification Toolbox for Design of Experiments
% Benjamin Hartmann, 05-April-2012
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles


% Find next incremental value as query point that can be measured without
% rounding the query value.
queryNew = NaN(size(query));
for i = 1:size(varInc,1)
    b = [varInc(i,1):varInc(i,2):varInc(i,3)]';
    for k = 1:size(query,1)
        a = query(k,i);
        c = sort([b; a]);
        idx = find(c==a); idx=idx(1);
        if idx > 1 & idx < size(c,1)
            delta1 = abs(c(idx-1)-a);
            delta2 = abs(c(idx+1)-a);
            if delta1 < delta2
                d = c(idx-1);
            else
                d = c(idx+1);
            end
        elseif idx == size(c,1)
            d = b(end);
        else
            d = b(1);
        end
        queryNew(k,i) = d;
    end
end
end