% HILOMOTDEMO HiLoMoT-Toolbox Demos
%
% HiLoMoT - Nonlinear System Identification Toolbox
% Benjamin Hartmann, 04-April-2012
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles


% Clearing
clear;
clear all;
close all;
clc

% Menu
i = menu('Choose one of the following examples:',...
    '1. Static process with 1 input and 1 output', ...
    '2. Static process with 2 inputs and 1 output', ...
    '3. Static process with 2 inputs and 2 outputs');

% Add path of HiLoMoT class files, if not existing already
me = mfilename;                    % What is my filename?
mydir = which(me);                 % Where am I located?
mydir = mydir(1:end-2-numel(me));
if isempty(strfind(path,mydir))
    addpath(mydir);
    addpath([mydir,'demo'])
end

% Execute demo program
if i == 1
    hilomotDemo1
elseif i == 2
    hilomotDemo2
elseif i == 3
    hilomotDemo3
end


% Clear variables
clear i hilomotDirectory hilomotDemoDirectory classesDirectory