% lolimotDemo1 Demo 1. Static process with 1 input and 1 output

% LoLiMoT - Nonlinear System Identification Toolbox
% Torsten Fischer, 20-October-2011
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles


% Training
LMN = lolimotPlus;                                    % Generate an empty net and data set structure

u = linspace(0,1,300)';
LMN.input = u;
LMN.output = 1 ./ (0.1 + u);

LMN.maxNumberOfLM = inf;                            % Termination criterion for maximal number of LLMs
LMN.minError = 0.005;                             % Termination criterion for minimal error
LMN.kStepPrediction = 0;                          % Static model
LMN.smoothness = 0.8;                             % Less overlap between the validity functions
LMN.complexityPenalty = 1;                        % Increase penalty for model complexity
LMN.history.displayMode = true;                   % display information
LMN.xRegressorDegree = 5;
LMN.zInputDelay = cell(1,1);
LMN.zInputDelay{1} = [];


LMN.LOOCV = true;

% Train net
LMN = LMN.train;

% Find best performance/complexity trade-off
[~, idxBest] = min(LMN.history.penaltyLossFunction);
LMN.leafModels = LMN.history.leafModelIter{idxBest};


% Generalization
uG = linspace(-0.05,1.2,270)';
yG = 1 ./ (0.1 + uG);

% Simulate net
yGModel = calculateModelOutput(LMN, uG, yG);
JG = calcGlobalLossFunction(LMN ,yG, yGModel);

figure
LMN.plotModel

figure
LMN.plotPartition