function combinationMatrix = buildCombinationMatrix(minInputs,maxInputs)
% Function creates a matrix, that contains all possible combinations of the
% inputs
%
% 
%
% INPUTS
%
% minInputs:                Integer value, that determines the minimum
%                           number of inputs
% maxInputs:                Integer value, that determines the maximum
%                           number of inputs
%
% OUTPUTS
%
% combinationMatrix:        nc x nx Matrix; Contains all possible
%                           combinations of the inputs from minInputs to
%                           maxInputs

% Julian Belz, 30-April-2012
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles

if nargin < 2
    error('Not enough input arguments!');
end

% Make sure the variables minInputs and maxInputs are scalar
if size(minInputs,1) ~= 1 || size(minInputs,2) ~= 1 || size(maxInputs,1) ~= 1 || ...
        size(maxInputs,2) ~= 1 || length(size(minInputs)) > 2 || length(size(maxInputs)) > 2
    error('Both input arguments must be scalars!');
end

% Determine the number of lines of the combinationMatrix
nc = 0;
for ii = minInputs:maxInputs-1
    nc = nc + factorial(maxInputs)/(factorial(maxInputs-ii)*factorial(ii));
end

% Predefine combinationMatrix
combinationMatrix = false(nc,maxInputs);

% 
lastLine = 1;
for ii = minInputs:maxInputs-1
    % Calculate matrix containing all combinations of length ii
%     tmpCombinations = sensitivityAnalysis.combinations(1:maxInputs,ii);
    tmpCombinations = nchoosek(1:maxInputs,ii);
    
    helpMeCount = 1;
    for jj = lastLine:lastLine+size(tmpCombinations,1)-1
        combinationMatrix(jj,tmpCombinations(helpMeCount,:)) = true;
        helpMeCount = helpMeCount + 1;
    end
    lastLine = lastLine + size(tmpCombinations,1);
end

% Add one line where all inputs are selected
combinationMatrix = [true(1,maxInputs);combinationMatrix];

end